/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Logger;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.FileClasspathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.JARClasspathLocation;

public abstract class AbstractClassPathLocation {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    final URI location;
    final String realm;
    final JARCache cache;
    JARCache.JARInformation cacheEntry = null;

    AbstractClassPathLocation(JARCache cache, String realm, URI location) {
        this.cache = cache;
        this.realm = realm;
        this.location = location;
    }

    public static AbstractClassPathLocation newClasspathLocation(JARCache cache, String realm, URI location) {
        if (location.toString().endsWith(".jar")) {
            return new JARClasspathLocation(cache, realm, location);
        }
        return new FileClasspathLocation(cache, realm, location);
    }

    public URI getLocation() {
        return this.location;
    }

    public String getRealm() {
        return this.realm;
    }

    public abstract LocationType getType();

    public abstract Collection<String> listToplevelClassNames();

    public abstract Collection<String> listAllEntries();

    public abstract InputStream getInputStream(String var1);

    public static enum LocationType {
        JAR,
        DIRECTORY;

    }
}

