/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;

public class ClassPathLocator {
    private final JARCache cache;

    public ClassPathLocator(JARCache cache) {
        this.cache = cache;
    }

    public ClassPathLocator() {
        this(null);
    }

    public Collection<AbstractClassPathLocation> findBelow(URI toplevel) {
        ArrayList<AbstractClassPathLocation> rval = new ArrayList<AbstractClassPathLocation>();
        File startPoint = new File(toplevel);
        if (startPoint.isDirectory()) {
            File[] listFiles = startPoint.listFiles();
            boolean hasJARs = false;
            for (File file : listFiles) {
                if (!file.getAbsolutePath().endsWith(".jar")) continue;
                rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, file.toURI().toString(), file.toURI()));
                hasJARs = true;
            }
            if (hasJARs) {
                return rval;
            }
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
        }
        if (startPoint.isFile() && startPoint.getAbsolutePath().endsWith(".jar")) {
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, toplevel.toString(), toplevel));
        }
        return rval;
    }

    public Collection<AbstractClassPathLocation> findInCurrentClassPath() {
        String[] split;
        ArrayList<AbstractClassPathLocation> rval = new ArrayList<AbstractClassPathLocation>();
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        for (String string : split = classpath.split(pathSep)) {
            rval.add(AbstractClassPathLocation.newClasspathLocation(this.cache, "#classpath", new File(string).toURI()));
        }
        return rval;
    }
}

