/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;

public class JARClasspathLocation
extends AbstractClassPathLocation {
    public JARClasspathLocation(JARCache cache, String realm, URI location) {
        super(cache, realm, location);
    }

    public JARCache.JARInformation getCacheEntry() {
        if (this.getType() == AbstractClassPathLocation.LocationType.JAR && this.cache != null) {
            this.cacheEntry = this.cache.getJARInformationFor(this.location);
        }
        return this.cacheEntry;
    }

    @Override
    public AbstractClassPathLocation.LocationType getType() {
        return AbstractClassPathLocation.LocationType.JAR;
    }

    @Override
    public InputStream getInputStream(String file) {
        try {
            JarURLConnection connection = (JarURLConnection)new URI("jar:" + this.location + "!/").toURL().openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).equals(file)) continue;
                return jarFile.getInputStream(entry);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Collection<String> getPredefinedPluginList() {
        return null;
    }

    @Override
    public Collection<String> listAllEntries() {
        ArrayList<String> rval = new ArrayList<String>();
        try {
            JarURLConnection connection = (JarURLConnection)new URI("jar:" + this.location + "!/").toURL().openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                rval.add(name);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return rval;
    }

    @Override
    public Collection<String> listToplevelClassNames() {
        ArrayList<String> rval = new ArrayList<String>();
        this.getCacheEntry();
        try {
            JarURLConnection connection = (JarURLConnection)new URI("jar:" + this.location + "!/").toURL().openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                String name = entry.getName();
                name = name.replaceAll("/", ".");
                name = name.replaceAll("\\.class", "");
                rval.add(name);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (this.cacheEntry != null) {
            this.cacheEntry.classesValid = true;
        }
        return rval;
    }
}

