/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.loader;

import java.net.URI;
import java.util.Collection;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.ClassPathManager;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.ClassPathLocator;
import net.xeoh.plugins.base.impl.loader.AbstractLoader;

public class InternalClasspathLoader
extends AbstractLoader {
    public InternalClasspathLoader(PluginManagerImpl pluginManager) {
        super(pluginManager);
    }

    @Override
    public boolean handlesURI(URI uri) {
        return uri.getScheme().equals("classpath");
    }

    @Override
    public void loadFrom(URI url) {
        if (url.toString().equals("classpath://*")) {
            this.loadAllClasspathPluginClasses();
            return;
        }
        if (url.toString().startsWith("classpath://")) {
            String toLoad = url.toString().substring("classpath://".length());
            this.loadClassFromClasspathByName(toLoad);
            return;
        }
    }

    private void loadAllClasspathPluginClasses() {
        this.logger.finer("Starting classpath search ...");
        ClassPathManager manager = this.pluginManager.getClassPathManager();
        ClassPathLocator locator = this.pluginManager.getClassPathLocator();
        Collection<AbstractClassPathLocation> locations = locator.findInCurrentClassPath();
        for (AbstractClassPathLocation location : locations) {
            manager.registerLocation(location);
            Collection<String> candidates = manager.findSubclassesFor(location, Plugin.class);
            this.logger.finer("Found " + candidates.size() + " candidates.");
            for (String string : candidates) {
                this.tryToLoadClassAsPlugin(location, string);
            }
        }
    }

    private void loadClassFromClasspathByName(String toLoad) {
        this.logger.fine("Loading " + toLoad + " directly");
        this.tryToLoadClassAsPlugin(null, toLoad);
    }
}

