/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.impl.registry.PluggableClassMetaInformation;
import net.xeoh.plugins.base.impl.registry.PluggableMetaInformation;

public class PluginRegistry {
    private final Map<Plugin, PluggableMetaInformation> pluginMetaInformation = new HashMap<Plugin, PluggableMetaInformation>();
    private final Map<Class<? extends Plugin>, PluggableClassMetaInformation> pluginClassMetaInformation = new HashMap<Class<? extends Plugin>, PluggableClassMetaInformation>();

    public Collection<Plugin> getAllPlugins() {
        return this.pluginMetaInformation.keySet();
    }

    public PluggableMetaInformation getMetaInformationFor(Plugin plugin) {
        return this.pluginMetaInformation.get(plugin);
    }

    public PluggableClassMetaInformation getMetaInformationFor(Class<? extends Plugin> clazz) {
        return this.pluginClassMetaInformation.get(clazz);
    }

    public void clear() {
        this.pluginClassMetaInformation.clear();
        this.pluginMetaInformation.clear();
    }

    public void registerPlugin(Plugin plugin, PluggableMetaInformation metaInformation) {
        this.pluginMetaInformation.put(plugin, metaInformation);
    }

    public void registerPluginClass(Class<? extends Plugin> c, PluggableClassMetaInformation metaInformation) {
        this.pluginClassMetaInformation.put(c, metaInformation);
    }

    public Collection<Class<? extends Plugin>> getPluginClassesWithStatus(PluggableClassMetaInformation.PluginClassStatus status) {
        ArrayList<Class<? extends Plugin>> rval = new ArrayList<Class<? extends Plugin>>();
        Set<Class<? extends Plugin>> keySet = this.pluginClassMetaInformation.keySet();
        for (Class<? extends Plugin> class1 : keySet) {
            PluggableClassMetaInformation metaInformation = this.pluginClassMetaInformation.get(class1);
            if (metaInformation.pluginClassStatus != status) continue;
            rval.add(class1);
        }
        return rval;
    }
}

