/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.util;

import java.util.logging.Logger;
import net.xeoh.plugins.base.PluginConfiguration;

public class PluginConfigurationUtil {
    private final PluginConfiguration pluginConfiguration;
    final Logger logger = Logger.getLogger(this.getClass().getName());

    public PluginConfigurationUtil(PluginConfiguration pc) {
        this.pluginConfiguration = pc;
    }

    public int getInt(Class<?> root, String subkey, Integer ... defautvalue) {
        String configuration = this.pluginConfiguration.getConfiguration(root, subkey);
        if (configuration == null) {
            if (defautvalue.length >= 1) {
                return defautvalue[0];
            }
            this.logger.warning("Returning default 0, but nothing was specified. Your application might behave strangely. Subkey was " + subkey);
            return 0;
        }
        return Integer.parseInt(configuration);
    }

    public String getString(Class<?> root, String subkey, String ... defautvalue) {
        String configuration = this.pluginConfiguration.getConfiguration(root, subkey);
        if (configuration == null) {
            if (defautvalue.length >= 1) {
                return defautvalue[0];
            }
            this.logger.warning("Returning default '', but nothing was specified. Your application might behave strangely. Subkey was " + subkey);
            return "";
        }
        return configuration;
    }

    public float getFloat(Class<?> root, String subkey, Float ... defautvalue) {
        String configuration = this.pluginConfiguration.getConfiguration(root, subkey);
        if (configuration == null) {
            if (defautvalue.length >= 1) {
                return defautvalue[0].floatValue();
            }
            this.logger.warning("Returning default '', but nothing was specified. Your application might behave strangely. Subkey was " + subkey);
            return 0.0f;
        }
        return Float.parseFloat(configuration);
    }

    public boolean getBoolean(Class<?> root, String subkey, Boolean ... defautvalue) {
        String configuration = this.pluginConfiguration.getConfiguration(root, subkey);
        if (configuration == null) {
            if (defautvalue.length >= 1) {
                return defautvalue[0];
            }
            this.logger.warning("Returning default '', but nothing was specified. Your application might behave strangely. Subkey was " + subkey);
            return false;
        }
        return Boolean.parseBoolean(configuration);
    }

    public double getDouble(Class<?> root, String subkey, Double ... defautvalue) {
        String configuration = this.pluginConfiguration.getConfiguration(root, subkey);
        if (configuration == null) {
            if (defautvalue.length >= 1) {
                return defautvalue[0];
            }
            this.logger.warning("Returning default '', but nothing was specified. Your application might behave strangely. Subkey was " + subkey);
            return 0.0;
        }
        return Double.parseDouble(configuration);
    }
}

