/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;

abstract class DocValuesFieldUpdates {
    final String field;
    final Type type;

    protected DocValuesFieldUpdates(String field, Type type) {
        this.field = field;
        this.type = type;
    }

    public abstract void add(int var1, Object var2);

    public abstract Iterator iterator();

    public abstract void merge(DocValuesFieldUpdates var1);

    public abstract boolean any();

    static class Container {
        final Map<String, NumericDocValuesFieldUpdates> numericDVUpdates = new HashMap<String, NumericDocValuesFieldUpdates>();
        final Map<String, BinaryDocValuesFieldUpdates> binaryDVUpdates = new HashMap<String, BinaryDocValuesFieldUpdates>();

        Container() {
        }

        boolean any() {
            for (NumericDocValuesFieldUpdates numericDocValuesFieldUpdates : this.numericDVUpdates.values()) {
                if (!numericDocValuesFieldUpdates.any()) continue;
                return true;
            }
            for (BinaryDocValuesFieldUpdates binaryDocValuesFieldUpdates : this.binaryDVUpdates.values()) {
                if (!binaryDocValuesFieldUpdates.any()) continue;
                return true;
            }
            return false;
        }

        int size() {
            return this.numericDVUpdates.size() + this.binaryDVUpdates.size();
        }

        DocValuesFieldUpdates getUpdates(String field, Type type) {
            switch (type) {
                case NUMERIC: {
                    return this.numericDVUpdates.get(field);
                }
                case BINARY: {
                    return this.binaryDVUpdates.get(field);
                }
            }
            throw new IllegalArgumentException("unsupported type: " + (Object)((Object)type));
        }

        DocValuesFieldUpdates newUpdates(String field, Type type, int maxDoc) {
            switch (type) {
                case NUMERIC: {
                    assert (this.numericDVUpdates.get(field) == null);
                    NumericDocValuesFieldUpdates numericUpdates = new NumericDocValuesFieldUpdates(field, maxDoc);
                    this.numericDVUpdates.put(field, numericUpdates);
                    return numericUpdates;
                }
                case BINARY: {
                    assert (this.binaryDVUpdates.get(field) == null);
                    BinaryDocValuesFieldUpdates binaryUpdates = new BinaryDocValuesFieldUpdates(field, maxDoc);
                    this.binaryDVUpdates.put(field, binaryUpdates);
                    return binaryUpdates;
                }
            }
            throw new IllegalArgumentException("unsupported type: " + (Object)((Object)type));
        }

        public String toString() {
            return "numericDVUpdates=" + this.numericDVUpdates + " binaryDVUpdates=" + this.binaryDVUpdates;
        }
    }

    static abstract class Iterator {
        Iterator() {
        }

        abstract int nextDoc();

        abstract int doc();

        abstract Object value();

        abstract void reset();
    }

    static enum Type {
        NUMERIC,
        BINARY;

    }
}

