/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.lucene.util.BytesRef;

public abstract class StringHelper {
    private static Comparator<String> versionComparator = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            StringTokenizer aTokens = new StringTokenizer(a, ".");
            StringTokenizer bTokens = new StringTokenizer(b, ".");
            while (aTokens.hasMoreTokens()) {
                int aToken = Integer.parseInt(aTokens.nextToken());
                if (bTokens.hasMoreTokens()) {
                    int bToken = Integer.parseInt(bTokens.nextToken());
                    if (aToken == bToken) continue;
                    return aToken < bToken ? -1 : 1;
                }
                if (aToken == 0) continue;
                return 1;
            }
            while (bTokens.hasMoreTokens()) {
                if (Integer.parseInt(bTokens.nextToken()) == 0) continue;
                return -1;
            }
            return 0;
        }
    };
    public static final int GOOD_FAST_HASH_SEED;

    public static int bytesDifference(BytesRef left, BytesRef right) {
        int len = left.length < right.length ? left.length : right.length;
        byte[] bytesLeft = left.bytes;
        int offLeft = left.offset;
        byte[] bytesRight = right.bytes;
        int offRight = right.offset;
        for (int i = 0; i < len; ++i) {
            if (bytesLeft[i + offLeft] == bytesRight[i + offRight]) continue;
            return i;
        }
        return len;
    }

    private StringHelper() {
    }

    public static Comparator<String> getVersionComparator() {
        return versionComparator;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static boolean startsWith(BytesRef ref, BytesRef prefix) {
        return StringHelper.sliceEquals(ref, prefix, 0);
    }

    public static boolean endsWith(BytesRef ref, BytesRef suffix) {
        return StringHelper.sliceEquals(ref, suffix, ref.length - suffix.length);
    }

    private static boolean sliceEquals(BytesRef sliceToTest, BytesRef other, int pos) {
        if (pos < 0 || sliceToTest.length - pos < other.length) {
            return false;
        }
        int i = sliceToTest.offset + pos;
        int j = other.offset;
        int k = other.offset + other.length;
        while (j < k) {
            if (sliceToTest.bytes[i++] == other.bytes[j++]) continue;
            return false;
        }
        return true;
    }

    public static int murmurhash3_x86_32(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= -862048943;
            k1 = Integer.rotateLeft(k1, 15);
            h1 ^= (k1 *= 461845907);
            h1 = Integer.rotateLeft(h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int murmurhash3_x86_32(BytesRef bytes, int seed) {
        return StringHelper.murmurhash3_x86_32(bytes.bytes, bytes.offset, bytes.length, seed);
    }

    static {
        String prop = System.getProperty("tests.seed");
        if (prop != null) {
            if (prop.length() > 8) {
                prop = prop.substring(prop.length() - 8);
            }
            GOOD_FAST_HASH_SEED = (int)Long.parseLong(prop, 16);
        } else {
            GOOD_FAST_HASH_SEED = (int)System.currentTimeMillis();
        }
    }
}

