/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import com.ericsson.neptune.security.util.EncodingUtils;
import com.ericsson.neptune.security.util.HttpURLUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OAuth2Util {
    public static final String STATE_SECURITY_TOKEN = "security_token";
    public static final String STATE_REDIRECT_URI = "redirect_uri";
    private static final Logger LOG = Logger.getLogger(OAuth2Util.class);

    private OAuth2Util() {
    }

    public static String encodeStateWithCallbackURL(String originalStateParam, String callbackUrl) {
        String encodedSecurityToken = EncodingUtils.encodeURL(originalStateParam, StandardCharsets.UTF_8.name());
        String encodedCallbackUrl = EncodingUtils.encodeURL(callbackUrl, StandardCharsets.UTF_8.name());
        String stateWithCallbackUrl = String.format("%s=%s&%s=%s", STATE_SECURITY_TOKEN, encodedSecurityToken, STATE_REDIRECT_URI, encodedCallbackUrl);
        return EncodingUtils.encodeBase64(stateWithCallbackUrl);
    }

    public static Map<String, String> decodeOAuth2StateParameter(String encodedStateParam) {
        String decodedStateWithCallbackUrl = EncodingUtils.decodeBase64(encodedStateParam);
        Map<String, String> paramMap = HttpURLUtil.parseQueryString(decodedStateWithCallbackUrl);
        if (paramMap == null || paramMap.isEmpty()) {
            return Collections.emptyMap();
        }
        String decodedSecurityToken = EncodingUtils.decodeURL(paramMap.get(STATE_SECURITY_TOKEN), StandardCharsets.UTF_8.name());
        String decodedCallbackUrl = EncodingUtils.decodeURL(paramMap.get(STATE_REDIRECT_URI), StandardCharsets.UTF_8.name());
        return Collections.singletonMap(decodedSecurityToken, decodedCallbackUrl);
    }

    public static String getCallbackURLFromStateParameter(String encodedStateParam, String defaultValue) {
        String callbackUrl = defaultValue;
        Map<String, String> stateRedirectUriPair = OAuth2Util.decodeOAuth2StateParameter(encodedStateParam);
        ArrayList<String> strings = new ArrayList<String>(stateRedirectUriPair.values());
        String decodedCallbackUrl = null;
        if (!strings.isEmpty()) {
            decodedCallbackUrl = strings.get(0);
        }
        if (StringUtils.isNotBlank(decodedCallbackUrl)) {
            callbackUrl = decodedCallbackUrl;
            LOG.debug((Object)("Pased callback url from state parameter: " + callbackUrl));
        } else {
            LOG.warn((Object)"Failed to parse callback URL while received authorization code token: invalid state parameter");
        }
        return callbackUrl;
    }
}

