
package com.smartgwt.client.docs;

/**
 * Like client-server desktop applications, SmartGWT browser-based applications interact&#010 with remote data and services via background communication channels. Background requests&#010 retrieve chunks of data rather than new HTML pages, and update your visual components in&#010 place rather than rebuilding the entire user interface.&#010 <P>&#010 SmartGWT supports two general classes of client-server operations:&#010 {@link com.smartgwt.client.data.DSRequest} (DataSource Requests) and {@link com.smartgwt.client.rpc.RPCRequest}s (Remote Procedure&#010 Call Requests).  DataSource requests are for manipulating structured data described by&#010 {@link com.smartgwt.client.data.DataSource}.  RPCRequests are a low-level, very flexible mechanism for&#010 custom client-server communications.  In an nutshell, RPCRequests:&#010 <ul>&#010 <li> may contain arbitrary data&#010 <li> are always initiated by custom code (a call to {@link com.smartgwt.client.rpc.RPCManager#send}), and have&#010 their responses handled by custom code (the callback passed to <code>send()</code>)&#010 </ul>&#010 <P>&#010 DSRequests:&#010 <ul>&#010 <li> contain data that follows the {@link com.smartgwt.client.docs.DataSourceOperations 'DataSource protocol'},&#010 which reflect the 4 basic operations on stored records: fetch, update, create, remove.&#010 <li> are initiated by {@link com.smartgwt.client.widgets.DataBoundComponent} in response to user&#010 actions, and have their responses automatically managed (for example, &#010 {@link com.smartgwt.client.data.ResultSet} and &#010 {@link com.smartgwt.client.widgets.form.DynamicForm#saveData}).  DSRequests can also be&#010 initiated manually and have their responses handled with custom code.&#010 </ul>&#010 See the {@link com.smartgwt.client.rpc.RPCManager} documentation for further information on RPCRequests - the&#010 remainder of this document focuses on integrating DataSource operations with your server.&#010 <P>&#010 <b>DataSource Creation</b>&#010 <p>&#010 First you must create {@link com.smartgwt.client.data.DataSource} that describe the objects from&#010 your object model that will be loaded or manipulated within your application.  All of ISC's&#010 most powerful functionality builds on the concept of a DataSource, and because of ISC's &#010 databinding framework (see {@link com.smartgwt.client.widgets.DataBoundComponent}), it's as easy to create a&#010 DataSource that can configure an unlimited number of components as it is to configure a&#010 single component.&#010 <P>&#010 There are a number of options for creating DataSources; for early prototyping, creating a&#010 DataSource by hand in either JavaScript or XML is simplest (this is covered under &#010 {@link com.smartgwt.client.docs.DataSourceDeclaration 'DataSource declaration'}).  Later on, you can pursue one of&#010 many {@link com.smartgwt.client.docs.MetadataImport 'metadata import'} strategies for automatically leveraging&#010 your existing metadata.&#010 <p>&#010 Once you have a DataSource, you can bind a {@link com.smartgwt.client.widgets.DataBoundComponent} such as a &#010 {@link com.smartgwt.client.widgets.grid.ListGrid} to it, call one of the &#010 {@link com.smartgwt.client.docs.DataBoundComponentMethods 'DataBound Component Methods'} on it, such as&#010 {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData}, the ListGrid will send a background HTTP request to the&#010 server asking for data.  You can set the log category "RPCManager" to DEBUG threshold to see&#010 the outbound request and the server's response.&#010 <P>&#010 In this case, the ListGrid is sending a DataSource operation request of type "fetch".  To&#010 fulfill it, you will need to provide a set of matching records in one of many possible&#010 formats.&#010 <P>&#010 At this point your code is just a handful of lines (this example shows a DataSource created&#010 in JavaScript):&#010 <pre>&#010     DataSource.create({&#010         ID:"employees",&#010         fields:[ &#010             ... &#010         ]&#010     });&#010     ListGrid.create({&#010         ID:"myGrid",&#010         dataSource:"employees"&#010     });&#010     myGrid.fetchData();&#010 </pre>&#010 If you now bind a {@link com.smartgwt.client.widgets.form.DynamicForm} to your DataSource, you can use the &#010 {@link com.smartgwt.client.widgets.form.DynamicForm#editSelectedData} and {@link com.smartgwt.client.widgets.form.DynamicForm#saveData}&#010 methods to cause the client to submit "update" operations.  For both "update" and "add"&#010 operations, the DSRequest object you receive will have inbound data that is expected to be&#010 committed to your data model.  &#010 <P>&#010 <b>Data Integration</b>&#010 <P>&#010 There are two main approaches to integrating DataSources with your server technology:&#010 <ul>&#010 <li> {@link com.smartgwt.client.docs.ServerDataIntegration 'Server-side integration'}: DataSource requests from&#010 the browser arrive as Java Objects on the server.  You deliver responses to the browser by&#010 returning Java Objects.&#010 <li> {@link com.smartgwt.client.docs.ClientDataIntegration 'Client-side integration'}: DataSource requests arrive&#010 as simple HTTP requests which your server code receives directly (in Java, you use the&#010 Servlet API or .jsps to handle the requests).  Responses are sent as XML or JSON which you&#010 directly generate.  &#010 </ul>&#010 Note that using WSDL-described web services is also considered a client-side integration&#010 approach, although in this case it is typical to use extensive third-party web service&#010 libraries such as <a href='http://ws.apache.org/axis/' onclick="window.open('http://ws.apache.org/axis/');return false;">Apache Axis</a> to provide Java&#010 bindings.&#010 <P>&#010 The possible approaches are summarized in the diagram below.  Paths 2, 3, and 4 are&#010 client-side integration approaches, and path 1 includes all server-side integration&#010 approaches.&#010 <P>&#010 <img src="${isc.DocViewer.instance.referenceRoot}skin/ds_bindings.png" width=763 height=475>&#010 <P>&#010 All of these integration options can be used in parallel within the same application.  For&#010 example, an application that typically talks to a Java backend may contact Yahoo's&#010 JSON-based search services to get related search results, or integrate with SalesForce&#010 applications via the AppForce WSDL-described web service.&#010 <P>&#010 If you cannot install the SmartGWT Server or must integrate with a pre-existing web&#010 service, then you must pursue {@link com.smartgwt.client.docs.ClientDataIntegration 'client-side integration'}.&#010 Otherwise there are several factors to consider:&#010&#010 <ul>&#010&#010 <li> With an existing Java backend, the fastest integration approach is&#010 {@link com.smartgwt.client.docs.ServerDataIntegration 'server-side integration'} using &#010 {@link com.smartgwt.client..DMI}.  Given &#010 a Java method that returns a Collection of POJOs, a short XML declaration will achieve&#010 data loading.</li>&#010&#010 <li> If you are building an &#010 <a href='http://www.google.com/search?q=SOA+architecture' onclick="window.open('http://www.google.com/search?q=SOA+architecture');return false;">SOA Architecture</a>, and some of&#010 the services that your SmartGWT application needs to contact could be shared with other&#010 kinds of clients, consider the WSDL- or XML-based&#010 {@link com.smartgwt.client.docs.ClientDataIntegration 'Client-Side Integration'}.</li>&#010&#010 <li> The SmartGWT server accelerates Java integration and provides various useful&#010 facilities, including the broadest possible browser support, server-push, and network&#010 performance enhancements.  See the {@link com.smartgwt.client.docs.IscServer 'SmartGWT Server Summary'} for&#010 details.</li>&#010&#010 </ul>
 */
public interface ClientServerIntegration {
}
