
package com.smartgwt.client.docs;

/**
 * A DataSource Operation is a type of {@link com.smartgwt.client.docs.Operations 'operation'} that acts on the set&#010 of stored objects represented by a {@link com.smartgwt.client.data.DataSource}, performing one of the basic actions&#010 that makes sense on a set of similar records: "fetch", "add", "update" or "remove".  &#010 <P>&#010 Each DataSource operation has specific request and response data, for example, in the&#010 "fetch" DataSource operation, the request data is expected to be search criteria, and the&#010 response data is expected to be a list of matching DataSource records.  Listed below are the&#010 request data and response data for each DataSource operation type, and what they mean.  &#010 <P>&#010 DataSource records are represented on the client by a JavaScript Object,&#010 where each property in the Object maps a DataSource field name to the field value - hence&#010 the DataSource operations below are in essence a way of exchanging records from client to&#010 server and back.&#010 <P>&#010 If you are using {@link com.smartgwt.client.docs.ServerDataIntegration 'server-side data integration'} with the&#010 SmartGWT Java server, see the ${isc.DocUtils.linkForDocNode('javaServerReference', 'Java Server Reference')} for&#010 information about how DataSource Requests arrive on the server (specifically&#010 com.isomophic.datasource.DSRequest) and how to provide responses &#010 (specifically com.isomorphic.datasource.DSResponse.setData()).&#010 <P>&#010 If you are using {@link com.smartgwt.client.docs.ClientDataIntegration 'client-side data integration'} to directly&#010 consume services that use XML, JSON or other formats, see the "Editing and Saving" section&#010 of the {@link com.smartgwt.client.docs.ClientDataIntegration 'client-side data integration'} topic.&#010 <P>&#010&#010 <b>fetch</b>&#010 <ul>&#010 <li>Request data: filter criteria, as an Object&#010 <li>Response data: matching records, as an Array of Objects&#010 </ul>&#010&#010 <b>add</b>&#010 <ul>&#010 <li>Request data: new record, as an Object&#010 <li>Response data: new record as stored, as an Object&#010 </ul>&#010&#010 <b>update</b>&#010 <ul>&#010 <li>Request data: primary keys of record to update, and new values (or just complete updated&#010 record), as an Object&#010 <li>Response data: new record as stored, as an Object&#010 </ul>&#010&#010 <b>remove</b>&#010 <ul>&#010 <li>Request data: primary keys of record to delete, as an Object&#010 <li>Response data: minimally the primary keys of deleted record (can be complete record), as&#010 an Object&#010 </ul>
 */
public interface DataSourceOperations {
}
