
package com.smartgwt.client.docs;

/**
 * This overview serves as a how-to for installing SmartGWT into your web application.&#010 Evaluators are urged to use the SmartGWT SDK with the embedded tomcat servlet engine&#010 during evaluation rather than pursue installation into an existing web application up front,&#010 however, reading this document and the related {@link com.smartgwt.client.docs.ClientServerIntegration 'server&#010 integration'} materials is recommended to get an overview.&#010 <P>&#010 SmartGWT has two pieces - the client components that run in the browser and the server&#010 components that run in a J2SE compatible container.  You don't need to use a Java back-end&#010 to use SmartGWT, but the SDK comes with some examples that assume the presence of the&#010 Java back-end and, for some examples, a SQL Database.  If you will be using SmartGWT with&#010 a Java back-end, see below for the list of J2SE application servers supported by the Java&#010 implementation of the SmartGWT server.&#010 <p>&#010 The SDK contains two top-level directories: <code>smartclientSDK</code> and&#010 <code>smartclientRuntime</code>.  The <code>smartclientSDK</code> directory contains the&#010 membedded servlet engine, embedded database, examples, and documentation.  The&#010 <code>smartclientRuntime</code> directory contains just the client and server components of&#010 the SmartGWT product - use the contents of this directory when deploying SmartGWT into&#010 your application environment.&#010 <p>&#010 <u><b>Client integration</b></u>&#010 <p>&#010 To install the client-side portion of SmartGWT, simply copy the <code>isomorphic</code>&#010 directory from the smartclientRuntime webroot to the webroot of your application.  Having&#010 done this you can use SmartGWT components on your pages regardless of the technologies&#010 used on your back-end and you can bind to server-side componentry backed by arbitrary&#010 technology - see the <i>Data Integration</i> section of the&#010 {@link com.smartgwt.client.docs.ClientServerIntegration} section for more information.&#010 <p>&#010 <u><b>Server integration</b></u>&#010 <p>&#010 SmartGWT can be {@link com.smartgwt.client.docs.NonJavaBackend 'integrated with any backend'} without&#010 installing the SmartGWT Java server.  However, the SmartGWT server accelerates Java&#010 integration and provides other useful facilities, including server-push and network&#010 performance enhancements.  See the {@link com.smartgwt.client.docs.IscServer 'SmartGWT Server summary'} for&#010 details.&#010 <P>&#010 To integrate the server portion of SmartGWT, you need to follow the steps below for each&#010 application (WAR) that uses SmartGWT.  Note that, if installing into an environment that&#010 uses multiple WARs, installation of SmartGWT JARs into a directory shared by multiple&#010 applications is not supported.  Installation of a separate WAR with client-side SmartGWT&#010 modules for maintaining cache coherence across applications using the same version of ISC is&#010 supported - contact Isomorphic support for more details on how to set that up.&#010 <p>&#010 <span style='color:red'>Note:</span> Some of the instructions below ask you to copy files&#010 into the WEB-INF/classes folder.  If you're using an IDE such as Eclipse that attempts to&#010 manage the WEB-INF/classes folder, we recommend that you copy these files to the src/&#010 directory of your project (next to the top-level folder for your java namespace) such that&#010 your IDE auto-deploys them to the WEB-INF/classes folder.  We have seen cases of tools like&#010 Eclipse periodically deleting files that are checked into to WEB-INF/classes directly.&#010 <p>&#010 <ul>&#010 <li> Copy all files from WEB-INF/lib directory of the smartclientRuntime to your&#010 WEB-INF/lib.  SmartGWT&#010 leverages a number of third-party libraries - if there are conflicts with the versions you&#010 want to use, use the versions you want - SmartGWT has minimal dependencies on these&#010 libraries.  Contact Isomorphic with any specific questions about compatibility.&#010 See the "Java Module Dependencies" section below for a dependency tree that will&#010 help you select a minimal set of JARs to deploy.&#010 <li> Copy the WEB-INF/classes/log4j.isc.config.xml from the smartclientRuntime to your&#010 WEB-INF/classes&#010 directory.  This file contains the SmartGWT server log configuration.&#010 <li> Copy the WEB-INF/classes/server.properties from the smartclientRuntime to your WEB-INF/classes&#010 directory.  This file contains settings for basic file locations such the location of&#010 webroot, the SmartGWT SQL engine and DMI.  The version under smartclientRuntime has a&#010 basic, secure configuration.  See the version of server.properties under the&#010 smartclientSDK directory for sample SQL and other settings.&#010 <li> Copy the WEB-INF/iscTaglib.xml from the smartclientRuntime to your WEB-INF directory.&#010 This file enables the use of custom SmartGWT tags in your JSPs.  &#010 <li> Merge portions of the WEB-INF/web.xml into your application's web.xml.  To use&#010 SmartGWT JSP tags like &lt;loadISC&gt;, you'll need to merge the &lt;jsp-config&gt;&#010 section from web.xml.  Also there are some mandatory and optional servlets and filters to&#010 merge - see below.&#010 <li> <b>Enterprise only</b>.  Copy the shared/ds/batchUpload.ds.xml file to the same location &#010 in your target webapp directory.  This file is a utility DataSource that is used to provide &#010 the initial upload functionality of the {@link com.smartgwt.client..BatchUploader} component - strictly speaking, &#010 you only need to perform this step if you intend to use that component.&#010 &#010 </ul>&#010 <u>Merging web.xml</u>&#010 <p>&#010 The following is a description of the servlets and filters you'll find in the web.xml file&#010 contained in the smartclientRuntime and what they do:&#010 <p>&#010 <i>Core Functionality</i>&#010 <ul>&#010 <li>Init servlet- <b>required:</b> initializes the SmartGWT server componentry from config files&#010 at container startup time.  Notice that this servlet has no mapping - it's purely an&#010 initialization servlet.&#010 <li>IDACall servlet - <b>required</b> for {@link com.smartgwt.client..DMI}, built-in RPC operations and built-in DataSource&#010 operations to work.  All databound examples in the SDK use this servlet.  If you're planning on&#010 using a custom actionURL for all your RPC requests, then you don't need this servlet.&#010 <li>FileDownload servlet - required for serving the Isomorphic framework code compressed and with&#010 caching headers as well as for serving skin images with caching headers.  It is highly&#010 recommended that you use this for production but is not required. &#010 <li>PreCache servlet - loads resources into memory on container startup.  Not required, but if you&#010 exclude this servlet there may be a slow response to the very first request.&#010 <li>jsp-config section - the iscTaglib registration block is required to use&#010 &lt;isomorphic&gt; tags, and the *.isc and *.rpc mappings.  These are optional, if you want&#010 to use these as handy development tools.&#010 </ul>&#010 <p>&#010 <i>Optional Functionality</i>&#010 <ul>&#010 <li>HttpProxy - used by the RPCManager when sending AJAX RPCs to a server other than the&#010 server that serves the main application page.  You need to install this servlet if, for&#010 example, your application will be querying web services exposed by servers other than the&#010 server that is serving the rest of the application.  See the javadoc for this servlet for&#010 various configuration options, such as how to restrict the URLs that are allowed to be&#010 proxied. &#010 <li>MessagingServlet - used by the realtime messaging system.  If you're planning&#010 on using this subsystem, you'll need this servlet.&#010 <li>CompressionFilter - required if you want to use dynamic compression of html and js&#010 files.&#010 <li>JSSyntaxScannerFilter - development tool that looks for trailing commas in JS&#010 source (scans html files for &lt;script&gt; tags and scans .js files in their entirety).&#010 This is a useful development tool, but should not be included in production.&#010 <li>NoCacheFilter - development tool that makes any content it intercepts non-cacheable in&#010 order to ensure developers are looking at the latest version of a file when modifying&#010 examples.  Not for production use.&#010 <li>DataSourceLoader - a servlet that returns the definition of one or more DataSources in&#010 JavaScript notation.  This servlet is provided as an alternative to using the &#010 <code>&lt;isomorphic:loadDS&gt;</code> JSP tag, and is particularly suitable in environments&#010 where JSP tags can't be used for some reason (such as with SmartGWT).  See &#010 {@link com.smartgwt.client.docs.DataSourceDeclaration 'Creating DataSources'} for more details.&#010 </ul>&#010 Note that not all of the servlets and filters listed under <i>Optional Functionality</i>&#010 above are present in the web.xml that ships with the smartclientRuntime - if you need to use&#010 any of these, copy their configuration from the web.xml available under the WEB-INF&#010 directory of smartclientSDK.  Other servlets, filters and configuration files from the&#010 smartclientSDK should not be copied to your deployment, simply because the SDK includes many&#010 developer tools that are not extensively audited from a security standpoint.&#010 <p>&#010 <u><b>Troubleshooting</b></u>&#010 <p>&#010 This section covers some common problems with possible solutions. You may also need to refer to the&#010 documentation for your specific application server, web server,  or database. If you experience any problems&#010 installing and configuring SmartGWT in your environment, please post on the &#010 <a href="http://forums.smartclient.com/" target='_blank'>SmartGWT forums</a> for&#010 assistance.&#010 <p>&#010 <table width="90%" class="normal" align="center" border="1" cellpadding="5">&#010 <tr bgcolor="#808080">&#010  <td width="30%"><b>Problem</b></td>&#010  <td width="30%"><b>Possible Causes</b></td>&#010  <td width="40%"><b>Solution</b></td>&#010 </tr><tr>&#010  <td rowspan='3'>Browser displays a generic "page cannot be displayed" or "unable to locate the server" message.</td>&#010  <td>Servlet engine not started.</td>&#010  <td>Start your application server.</td>&#010 </tr><tr>&#010  <td>Missing/incorrect port for servlet engine in URL.</td>&#010  <td>Check the startup messages, logs, or documentation for the servlet engine to determine what port it is using.</td>&#010 </tr><tr>&#010  <td>Host name is incorrect.</td>&#010  <td>Check whether other pages on the host can be accessed.&#010   Try the base URL http://[host name]:[port number] to see whether the servlet engine or webserver is functioning.</td>&#010 </tr><tr>&#010  <td>Browser displays a 404 or other page/file not found error.</td>&#010  <td>Incorrect URL.</td>&#010  <td>Check for errors in the URL, including capitalization.</td>&#010 </tr><tr>&#010  <td>Server error: taglib not defined</td>&#010  <td>Missing iscTaglib.xml or iscTaglib.xml not referenced in web.xml</td>&#010  <td>Copy WEB-INF/iscTaglib.xml from smartclientRuntime to your deployment WEB-INF directory&#010  and make sure that you have merged the &lt;jsp-config&gt; section from the&#010  smartclientRuntime web.xml</td>&#010 </tr><tr>&#010  <td>ClassNotFound or other Java Exceptions in the server log.</td>&#010  <td>Missing JAR files</td>&#010  <td>Verify every .jar from the smartclientRuntime WEB-INF/lib directory has been copied to&#010  your deployment WEB-INF/lib.  Although you might later be able to remove some .jars, for&#010  initial installation testing, copy every .jar</td>&#010 </tr><tr>&#010  <td>"isc" is not defined JS error</td>&#010  <td>Incorreect URLs to SmartGWT modules</td>&#010  <td>use View Source to look at SCRIPT includes (e.g. for ISC_Core.js), try those URLs&#010  directly in the browser to  verify the files are correctly deployed</td>&#010 </tr>&#010 </table>&#010 <P>&#010 <u><b>Java Module Dependencies</b></u>&#010 <p>&#010 The following is a description of what functionality is contained in each SmartGWT JAR&#010 file, and which other SmartGWT JARs and third party libraries are required to enable that&#010 functionality.  Note that actual filenames in WEB-INF/lib will typically contain the version&#010 number of the library, whereas the library names below simply list the base name.&#010 <ul>&#010 <li><b>isomorphic_core_rpc</b>: This is the core SmartGWT module.  It provides the RPC, DMI,&#010 and DataSource support.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-cli<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-lang<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-collections<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-pool<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-codec<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isc-jakarta-oro<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;log4j<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-jxpath<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-httpclient<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;velocity<br>&#010 &nbsp;&nbsp;<u>Optionally Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;xercesImpl - if you're using JDK &lt; 1.5<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;xml-apis - if you're using JDK &lt; 1.5<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-fileupload - if you plan to use the upload form item with&#010 SmartGWT processing.<br>&#010 </li>&#010 <li><b>isomorphic_web_services</b>: Web services examples only.  Contains code backing the&#010 SmartGWTOperations.wsdl example.  Do not deploy in production.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;axis<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;axis-schema<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-discovery<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-logging<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;jaxrpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;saaj<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;wsdl4j<br>&#010 </li>&#010 <li><b>isomorphic_tools</b>: Contains back-end logic for the "Admin Console" tool visible in&#010 the Developer Console, and also standalone from the SDK home page.  This is an SDK-only&#010 tool, not intended for production deployment, and further intended for rapid prototyping&#010 only.  Do not deploy this module to production, but you may use it in your development if&#010 you're using the SmartGWT rapid prototyping SQL engine.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_sql<br>&#010 </li>&#010 <li><b>isomorphic_embedded_tomcat</b>: This contains the bootstrap class for the Embedded&#010 Tomcat engine shipped with the SmartGWT SDK.  It is not intended to be used in any way&#010 other than via the start_embedded_tomcat.bat|sh|command scripts in the webRoot of the&#010 SDK.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;All JARs under WEB-INF/embeddedTomcat/lib<br>&#010 </li>&#010 <li><b>isomorphic_struts</b>: Contains the ValidationAction and ValidationFailureAction&#010 classes that implement RPC-based validation of DynamicForms using the Struts&#010 ValidatorPlugIn.  If you're not using Struts or if you don't need this particular feature of&#010 SmartGWT, you do not need this module or its dependencies.  An example of this style of&#010 validation is available here: <a href='/examples/struts/forms/welcome.do' onclick="window.open('/examples/struts/forms/welcome.do');return false;">/examples/struts/forms/welcome.do</a> - read the&#010 info on this page, and follow the "Dynamic Form (With RPC-based Validation) Link for&#010 the actual example.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;struts<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-digester<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-beanutils<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-fileupload<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-logging<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-validator<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;jakarta-oro<br>&#010 </li>&#010 <li><b>isomorphic_spring</b>: Required for {@link com.smartgwt.client..DMI} dispatches to Spring beans (via&#010 {@link com.smartgwt.client..ServerObject#getLookupStyle lookupStyle} : "spring").<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;spring<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-logging<br>&#010 </li>&#010 <li><b>isomorphic_examples</b>: Contains code for various SmartGWT examples shown in the&#010 SDK.  Do not deploy to production.  The source code for the compiled classes in this module&#010 are present in the SDK in various locations and typically linked to directly from the&#010 examples that use them.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_sql<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_struts<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_spring<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_hibernate<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-logging<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;jstl<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;jakarta-taglib-standard<br>&#010 </li>&#010 <li><b>isomorphic_realtime_messaging</b>: Server support required for the SmartGWT&#010 Realtime Messaging Module.  Install this if you're using this 'push' technology.  For more&#010 information, see: ${isc.DocUtils.linkForDocNode('Messaging QuickRef')}:<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 </li>&#010 <li><b>isomorphic_hibernate</b>: Contains support for Hibernate DataSources as described&#010 here: {@link com.smartgwt.client.docs.HibernateIntegration}.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;hibernate3<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-logging<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;dom4j<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;jdbc2_0-stdext<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;asm<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;asm-attrs<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;jta<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;cglib<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;antlr<br>&#010 &nbsp;&nbsp;<u>Optionally Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;hsqldb - not required for linking, but needed for Hibernate to&#010 actually connect to databases of this type, and hsqldb is what's used in the SDK examples.&#010 Note that for production use you will need a JDBC driver for your database type.<br>&#010 </li>&#010 <li><b>isomorphic_sql</b>: Implementation of the SmartGWT SQL rapid prototyping layer.&#010 This is a SQL generation engine similar to Hibernate, but not as flexible.  Some SQL-based&#010 SDK examples rely on this logic, but it should not be used in production.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br> &#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_hibernate<br> &#010 &nbsp;&nbsp;&nbsp;&nbsp;commons-dbcp<br> &#010 &nbsp;&nbsp;&nbsp;&nbsp;hsqldb<br> &#010 </li>&#010 <li><b>isomorphic_js_parser</b>: A parser capable of reading a JSON byte stream and creating&#010 an in-memory Java object structure to match.  Used by any mechanism that relies on&#010 JSON-style configuration.  Examples include FileAssembly definitions in JSON format, any use&#010 of the rulesFile with a URIRegexFilter (Java Servlet) or subclass.  Generally not&#010 required.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br> &#010 </li>&#010 <li><b>isomorphic_compression</b>: This is a part of the Network Performance Module.  The&#010 isomorphic_compression module is required for dynamic and static compression of various&#010 assets delivered to the browser.  For more information, see: &#010 {@link com.smartgwt.client.docs.Compression}.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br> &#010 </li>&#010 <li><b>isomorphic_assembly</b>: This is part of the Network Performance Module.  The&#010 isomorphic_assembly module is required for file assembly and stripping.  For more&#010 information, see: {@link com.smartgwt.client.docs.FileAssembly}.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br> &#010 &nbsp;&nbsp;<u>Optionally Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_obfuscation - for code obfuscation<br> &#010 </li>&#010 <li><b>isomorphic_obfuscation</b>: This is part of the Network Performance Module.  The&#010 isomorphic_obfuscation module is required to enable obfuscation of code assembled by the&#010 File Assembly system.  For more information, see: &#010 {@link com.smartgwt.client.docs.Compression}.<br>&#010 &nbsp;&nbsp;<u>Requires</u>:<br>&#010 &nbsp;&nbsp;&nbsp;&nbsp;isomorphic_core_rpc<br> &#010 </li>&#010 </ul>&#010 <p>&#010 <u><b>Caching Considerations</b></u>&#010 <p>&#010 When upgrading from one SmartGWT release to the next you want to make sure that the user&#010 picks up the new version on next access, but you also want to keep the ISC modules cacheable&#010 so they're not refetched on every access.&#010 <p>&#010 SmartGWT deals with this problem by appending a version string as a query parameter to&#010 each module load directive.  This is done by the &lt;isomorphic:loadISC&gt; and&#010 &lt;isomorphic:loadModules&gt; tags automatically.  As long as you make sure that the file&#010 that contains these tags is non-cacheable, you will get the desired behavior.&#010 <p>&#010 <u><b>Supported J2SE Containers</b></u>&#010 <p>&#010 Below is the list of J2SE containters that have been tested to be compatible with this&#010 version of SmartGWT.  Installation in these containers is supported for deployment by&#010 Isomorphic.  If your application server is not on this list, please contact us at the&#010 <a href="http://forums.smartclient.com" target='_blank'>SmartGWT forums</a> to see if we can support&#010 your deployment.  In general, the Java portion of ISC should work on servlet containers that&#010 comply with servlet specification version 2.3 and up and utilize a JVM no older than version&#010 1.4.&#010 <p>&#010 Supported J2SE Containers:&#010 <p>&#010 <table class='normal'>&#010 <tr><td width=40></td><td width=200><i>Apache Tomcat 4.0.x, 4.1.x, 5.0.x, 5.5x, 6.0.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>Apache Geronimo 1.x, 2.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>BEA WebLogic 6.x, 7x, 8.x, 9.x, 10.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>Caucho Resin 2.1.x, 3.0.x, 3.1.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>IBM WebSphere 5.x, 6.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>IBM WebSphere Community Edition 1.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>JBoss 3.2.x, 4.0.x, 4.2.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>Mortbay Jetty 4.x, 5.x, 6.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>Oracle Containers for J2EE (OC4J) 9.x, 10.x, 11.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>Oracle Application Server 10g 9.x, 10.x</i></td><td></td></tr>&#010 <tr><td></td><td><i>Sun Application Server 8.x, 9.x</i></td><td></td></tr>&#010 </table>
 */
public interface IscInstall {
}
