
package com.smartgwt.client.docs;

/**
 * Loading the SmartGWT framework into multiple frames or iframes within the same browser is&#010 not a supported configuration, or more accurately, not a <i>supportable</i> configuration,&#010 for the following reasons:&#010 <ul>&#010 <li> each additional frame multiplies the memory footprint and reduces speed&#010 <li> having multiple frames prevents drag and drop between components in different frames&#010 <li> modality handling (eg modal dialogs) doesn't automatically take into account multiple&#010 frames (consider tabbing order, nested modality and other issues, you'll see it's not&#010 realistic to provide automatic cross-frame modality handling)&#010 <li> inter-frame communication triggers several browser bugs: memory leaks, performance&#010 issues, intermittent crashes in some browsers, inconsistencies in basic JavaScript operators&#010 such as "typeof", and problems with form focus handling in IE, among many other bugs&#010 </ul>&#010 None of these problems are specific to SmartGWT.  They happen with Ajax frameworks in&#010 general as well as other RIA technologies.  This is why no successful Ajax application has&#010 ever used the approach of double-loading a component framework into multiple frames.&#010 <P>&#010 The recommended {@link com.smartgwt.client.docs.SmartArchitecture 'SmartGWT Architecture'} involves loading as many&#010 SmartGWT-based application views as possible in the first page load, then showing and&#010 hiding different views as the user navigates through the application.&#010 <P>&#010 If, for whatever reason, you cannot follow the SmartGWT Architecture and must load new&#010 SmartGWT-based views by contacting the server each time, use the {@link com.smartgwt.client.widgets.ViewLoader} class&#010 to load new views, never frames.&#010 <P>&#010 Note that the use of IFrames is appropriate in certain circumstances, including loading&#010 certain types of content within an {@link com.smartgwt.client.widgets.HTMLFlow}.  The only&#010 prohibited usage is loading the SmartGWT framework into multiple frames within the same&#010 browser.
 */
public interface NoFrames {
}
