
package com.smartgwt.client.docs;

/**
 * The SmartGWT {@link com.smartgwt.client.widgets.tree.TreeGrid} component is a visual representation of a tree and requires&#010 a {@link com.smartgwt.client.widgets.tree.Tree} or {@link com.smartgwt.client..ResultTree} datatype passed via the {@link com.smartgwt.client.widgets.tree.TreeGrid#getData data} attribute to&#010 initialize the tree view.  The {@link com.smartgwt.client.widgets.tree.Tree} datatype is used when you want to provide all of&#010 the tree nodes in one shot at initialization time.  The {@link com.smartgwt.client..ResultTree} datatype is used&#010 when you want portions of the tree to be loaded on demand from the server.&#010 <p>&#010 <b><u>Providing all data to the Tree at creation</u></b>&#010 <p>&#010 The simplest mechanism by which to initialize a Tree is to simply provide all the data&#010 up-front when the Tree itself is created.  Depending on the format of your tree data, this&#010 can be done by setting {@link com.smartgwt.client.widgets.tree.Tree#getRoot root} or {@link com.smartgwt.client.widgets.tree.Tree#getData data}.  This functionality is provided&#010 by the {@link com.smartgwt.client.widgets.tree.Tree} class.&#010 <p>&#010 For examples of this type of databinding, see the following SDK examples:&#010 <ul>&#010 <li><a href='/examples/components/treeGrid_init.html' onclick="window.open('/examples/components/treeGrid_init.html');return false;">TreeGrid Initialization Example</a>&#010 <li><a href='/examples/server_integration/#jstlTree' onclick="window.open('/examples/server_integration/#jstlTree');return false;">TreeGrid Initialization with JSTL</a>&#010 </ul>&#010 <p>&#010 <b><u>Loading Tree nodes on demand</u></b>&#010 <p>&#010 In this mode, tree nodes are loaded on-demand the first time a user expands a folder.  This&#010 approach is necessary for large trees.  This functionality is provided by the&#010 {@link com.smartgwt.client..ResultTree} class.&#010 <p>&#010 ResultTrees require that every node in the tree have an {@link com.smartgwt.client.widgets.tree.Tree#getIdField idField} that is&#010 unique tree-wide.  When the user expands a folder whose contents have not yet been loaded&#010 from the server (or you programmatically call openFolder() on such a node), the client&#010 automatically sends a {@link com.smartgwt.client.data.DSRequest} to the server to ask for all immediate children of&#010 that node.  The {@link com.smartgwt.client.data.DSRequest} criteria will specify the id of the node for which children&#010 are being requested via the <code>parentId</code> property (see {@link com.smartgwt.client.widgets.tree.Tree#getParentIdField parentIdField}).&#010 This client is asking the server: "give me all nodes whose parentId is the id of this&#010 node".&#010 <P>&#010 If there are no pre-existing node ids in the dataset you are loading, you must generate node&#010 ids (because the client needs some way to identify nodes when talking to the server).&#010 Generally a node id should contain whatever information is required to fetch the node and&#010 it's children on the server.  One typical approach is to use the path to the node as a node&#010 id.  For XML datasets in particular, the path may be a valid XPath, so that server-side&#010 lookup of child nodes is just a matter of applying the node id as an XPath to a server-side&#010 XMLDocument.&#010 <P>&#010 {@link com.smartgwt.client..ResultTree}s are created for you by the {@link com.smartgwt.client.widgets.tree.TreeGrid} when you set&#010 {@link com.smartgwt.client.widgets.tree.TreeGrid#getDataSource dataSource}, but you can pass an initial dataset to a databound TreeGrid by&#010 setting {@link com.smartgwt.client.widgets.tree.TreeGrid#getInitialData initialData}.  The {@link com.smartgwt.client.widgets.tree.Tree#getIdField idField} is derived from the dataSource&#010 you provide to the TreeGrid - the first field marked as&#010 {@link com.smartgwt.client.data.DataSourceField#getPrimaryKey primaryKey}:true becomes the idField of the ResultTree.&#010 The {@link com.smartgwt.client.widgets.tree.Tree#getParentIdField parentIdField} is found by looking for a field that has a&#010 {@link com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} property pointing to the idField.&#010 <P>&#010 If you do not provide {@link com.smartgwt.client.widgets.tree.TreeGrid#getInitialData initialData}, the first DSRequest you receive will be a&#010 request for the nodes under root.  The id of the root node of the tree is the value of the&#010 <code>rootValue</code> attribute on the {@link com.smartgwt.client.widgets.tree.Tree#getParentIdField parentIdField} of the Tree DataSource. &#010 <p>&#010 For examples of this type of databinding, see the following SDK examples:&#010 <ul>&#010 <li><a href='/examples/databinding/tree_databinding.jsp' onclick="window.open('/examples/databinding/tree_databinding.jsp');return false;">TreeGrid DataBinding Example</a>&#010 <li><a href='/examples/server_integration/#xml2JSLOD' onclick="window.open('/examples/server_integration/#xml2JSLOD');return false;">TreeGrid XML DataBinding</a>&#010 </ul>&#010 <P>&#010 <b><u>Multi-Level load on demand</u></b>&#010 <P>&#010 The ResultTree's DSRequests ask for the immediate children of a node only (by specifying&#010 <code>parentId</code> in the criteria). Any nodes returned whose <code>parentId</code> field&#010 value is unset or matches this criterion will be added to the tree as immediate children of the&#010 node. However you are also free to return multiple levels of children.  This can be done by&#010 simply returning a flat list of descendents with valid id's and parentId's, exactly as though &#010 you were initializing a multi-level tree via {@link com.smartgwt.client.widgets.tree.Tree#getData data}.  &#010 <P>&#010 Note that when receiving multiple levels of children, the ResultTree's assumption is that&#010 if any children are loaded for a parent, then that parent is considered fully loaded.&#010 <P>&#010 When loading children for a given parent node, the ResultTree calls&#010 {@link com.smartgwt.client.data.DataSource#fetchData} on its DataSource.  For custom code that may need to reference&#010 the parentNode or tree in some way, the parent node whose children are being loaded is&#010 available on the dsRequest instance in the DataSource flow as dsRequest.parentNode, where it&#010 can be inspected during {@link com.smartgwt.client.data.DataSource#transformRequest}.
 */
public interface TreeDataBinding {
}
