/*
 * SmartGWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * SmartGWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  SmartGWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
 
package com.smartgwt.client.widgets.form.validator;



import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.JSOHelper;
import com.smartgwt.client.util.EnumUtil;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;
   /**
    * A validator describes a check that should be performed on a value the user is trying to&#010 save.&#010 <p>&#010 Validators are specified for DataSource fields via the {@link com.smartgwt.client.data.DataSourceField#getValidators validators}&#010 property.  Validators that need not be run on the server can also be specified for a&#010 specific {@link com.smartgwt.client.widgets.form.fields.FormItem} or ${isc.DocUtils.linkForRef('object:ListGridField')}.&#010 <p>&#010 ISC supports a powerful library of {@link com.smartgwt.client..ValidatorTypes} which have identical behavior&#010 on both the client and the server.  &#010 <p> &#010 Beyond this, custom validators can be defined on the client and custom validation logic&#010 added on the server.  Note that the <code>regexp</code> and <code>mask</code> validator&#010 types are very flexible and can be used to perform virtually any kind of formatting check&#010 that doesn't involve some large external dataset.&#010 <p>&#010 Custom validators can be reused on the client by adding them to the global validator list,&#010 via the {@link com.smartgwt.client.widgets.form.validator.Validator#addValidator} method.

    */
public class Validator extends DataClass {

    public static Validator getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new Validator(jsObj);
    }


    public Validator(){
        
    }

    public Validator(JavaScriptObject jsObj){
        super(jsObj);
    }

    // ********************* Properties / Attributes ***********************

    /**
    * Normally, all validators defined for a field will be run even if one of the validators has&#010 already failed.  However, if <code>stopIfFalse</code> is set, validation will not proceed&#010 beyond this validator if the check fails.&#010 <P>&#010 This is useful to prevent expensive validators from being run unnecessarily, or to allow&#010 custom validators that don't need to be robust about handling every conceivable type of&#010 value.
    *
    * @param stopIfFalse stopIfFalse Default value is false
    */
    public void setStopIfFalse(Boolean stopIfFalse) {
        setAttribute("stopIfFalse", stopIfFalse);
    }
    /**
     * Normally, all validators defined for a field will be run even if one of the validators has&#010 already failed.  However, if <code>stopIfFalse</code> is set, validation will not proceed&#010 beyond this validator if the check fails.&#010 <P>&#010 This is useful to prevent expensive validators from being run unnecessarily, or to allow&#010 custom validators that don't need to be robust about handling every conceivable type of&#010 value.
     *
     *
     * @return Boolean
     *
     */
    public Boolean getStopIfFalse()  {
        return getAttributeAsBoolean("stopIfFalse");
    }

    /**
    * Indicates this validator runs on the client only.&#010 <p>&#010 Normally, if the server is trying to run validators and finds a validator that it can't&#010 execute, for safety reasons validation is considered to have failed.  Use this flag to&#010 explicitly mark a validator that only needs to run on the client.
    *
    * @param clientOnly clientOnly Default value is false
    */
    public void setClientOnly(Boolean clientOnly) {
        setAttribute("clientOnly", clientOnly);
    }
    /**
     * Indicates this validator runs on the client only.&#010 <p>&#010 Normally, if the server is trying to run validators and finds a validator that it can't&#010 execute, for safety reasons validation is considered to have failed.  Use this flag to&#010 explicitly mark a validator that only needs to run on the client.
     *
     *
     * @return Boolean
     *
     */
    public Boolean getClientOnly()  {
        return getAttributeAsBoolean("clientOnly");
    }

    // ********************* Methods ***********************


    // ********************* Static Methods ***********************







    /**
     * Text to display if the value does not pass this validation check. <P> If unspecified, default error messages
     * exist for all built-in validators, and a generic message will be used for a custom validator that is not passed.
     *
     * @param errorMessage errorMessage Default value is null
     */
    public void setErrorMessage(String errorMessage) {
        setAttribute("errorMessage", errorMessage);
    }

}



