/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.core.jmx;

import com.ireasoning.core.jmx.AdaptorServerMBean;
import com.ireasoning.core.jmx.State;
import com.ireasoning.core.network.SocketServer;
import com.ireasoning.core.network.f;
import com.ireasoning.core.network.g;
import com.ireasoning.core.network.i;
import com.ireasoning.core.network.m;
import com.ireasoning.util.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class AdaptorServer
implements AdaptorServerMBean,
Runnable,
MBeanRegistration {
    public static final int MAX_CONNECTIONS = 40;
    public static final int RECV_BUF_SIZE = 131072;
    public static final int TCP = 1;
    public static final int UDP = 0;
    protected static final int TCP_TL1 = 2;
    public static final String TL1 = "tl1";
    public static final String SNMP = "snmp";
    protected int _port;
    protected InetAddress _ipAddress;
    protected MBeanServer _mbeanServer;
    protected ObjectName _objectName;
    protected SocketServer _socketServer;
    protected Object _serverSocket;
    protected MBeanInfo _mbeaninfo;
    protected long _startTime;
    protected int _maxConnections = 40;
    protected int _transportLayerType;
    protected g _dataHandlerFactory;
    protected f _dataHandler;
    protected int _state = 3;
    private Thread a;

    protected AdaptorServer(MBeanServer mBeanServer, int n2) {
        this._mbeanServer = mBeanServer;
        this._port = n2;
    }

    protected AdaptorServer(MBeanServer mBeanServer, int n2, int n3, g g2) {
        this._mbeanServer = mBeanServer;
        this._port = n2;
        this._transportLayerType = n3;
        this._dataHandlerFactory = g2;
        this._port = n2;
    }

    protected AdaptorServer(MBeanServer mBeanServer, int n2, int n3, f f2) {
        this._mbeanServer = mBeanServer;
        this._port = n2;
        this._transportLayerType = n3;
        this._dataHandler = f2;
        this._port = n2;
    }

    private void a() throws IOException {
        if (this._transportLayerType == 1) {
            this._socketServer = new i();
            this._socketServer.open(this._port, this._maxConnections, this._ipAddress);
        } else if (this._transportLayerType == 2) {
            this._socketServer = new i(true);
            this._socketServer.open(this._port, this._maxConnections, this._ipAddress);
        } else if (this._transportLayerType == 0) {
            this._socketServer = new m();
            this._socketServer.open(this._port, 131072, this._ipAddress);
            this._socketServer.setDataHandler(this._dataHandler);
        } else {
            throw new IllegalArgumentException("Unknown transport layer type.");
        }
        this._socketServer.setDataHandlerFactory(this._dataHandlerFactory);
        this._serverSocket = this._socketServer.getServerSocket();
    }

    public Object getServerSocket() {
        return this._serverSocket;
    }

    public void setPort(int n2) {
        this._port = n2;
        if (this._state == 1) {
            Logger.info("Set new port number. Restart service...");
            this.stopService();
            try {
                this.startService();
            }
            catch (Exception exception) {
                Logger.error(exception);
                throw new RuntimeException(exception.toString());
            }
        }
    }

    public void setIpAddress(InetAddress inetAddress) {
        this._ipAddress = inetAddress;
        if (this._state == 1) {
            Logger.info("Set new ip address. Restart service...");
            this.stopService();
            try {
                this.startService();
            }
            catch (Exception exception) {
                Logger.error(exception);
                throw new RuntimeException(exception.toString());
            }
        }
    }

    public void setMaxConnections(int n2) {
        this._socketServer.setMaxConnections(n2);
    }

    public String getHost() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public int getPort() {
        return this._port;
    }

    public void run() {
        try {
            this._socketServer.process();
        }
        catch (IOException iOException) {
            Logger.error(iOException);
        }
    }

    public void startService() throws Exception {
        this._state = 0;
        this.a = new Thread((Runnable)this, "AdaptorServer");
        int n2 = Thread.currentThread().getPriority();
        if (n2 < 10) {
            ++n2;
        }
        this.a.setPriority(n2);
        Logger.info("Start initializing socket.");
        this.a();
        this.a.start();
        this._state = 1;
        this._startTime = System.currentTimeMillis();
    }

    public void stopService() {
        this._state = 2;
        this.a.interrupt();
        if (this._socketServer != null) {
            this._socketServer.close();
        }
        this._state = 3;
        this._socketServer = null;
    }

    public int getState() {
        return this._state;
    }

    public String getStateString() {
        return State.STATES[this._state];
    }

    public String getName() {
        return this.getProtocol();
    }

    public long getUptime() {
        return System.currentTimeMillis() - this._startTime;
    }

    public int getActiveClientCount() {
        if (this._socketServer == null) {
            return 0;
        }
        return this._socketServer.getActiveClientCount();
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl2) {
        if (!bl2.booleanValue()) {
            this._mbeanServer = null;
        }
    }

    public void preDeregister() throws Exception {
        this.stopService();
        this._objectName = null;
        this._mbeanServer = null;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this._objectName = objectName;
        this._mbeanServer = mBeanServer;
        if (this._socketServer != null) {
            this._socketServer.setMBeanServer(this._mbeanServer);
        }
        return objectName;
    }

    public static String getObjectName(String string, int n2) {
        String string2 = "Adaptor:name=" + string + ", port=" + n2 + ", vendor=iReasoning";
        Logger.debug("ObjectName", string2);
        return string2;
    }

    public abstract String getProtocol();
}

