/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.bc;
import com.ireasoning.util.Logger;
import com.ireasoning.util.bw;
import com.ireasoning.util.cd;
import com.ireasoning.util.e;

public class SnmpOctetString
implements SnmpDataType {
    byte[] a = null;

    public SnmpOctetString() {
    }

    public SnmpOctetString(String string) {
        this(string.getBytes());
    }

    public SnmpOctetString(byte[] byArray) {
        this();
        if (byArray != null) {
            this.a = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.a, 0, byArray.length);
        }
    }

    public SnmpOctetString(SnmpOctetString snmpOctetString) {
        this(snmpOctetString.a);
    }

    public int getLength() {
        int n2 = 0;
        if (this.a != null) {
            n2 = this.a.length;
        }
        return n2;
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "OctetString";
    }

    public String toString() {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.a.length - 1) {
            byte by2 = this.a[n2];
            if (!e.isDisplayable(by2)) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        byte[] byArray = this.a;
        if (this.a.length > 1) {
            if (this.a[this.a.length - 1] == 0) {
                byte[] byArray2 = new byte[this.a.length - 1];
                System.arraycopy(byArray, 0, byArray2, 0, this.a.length - 1);
                byArray = byArray2;
            }
        } else if (this.a.length == 1) {
            byte by3 = this.a[0];
            if (by3 != 0) {
                if (!e.isDisplayable(by3)) {
                    bl2 = true;
                }
            } else {
                byArray = new byte[]{};
            }
        }
        if (bl2) {
            return this.toHexString();
        }
        return bw.byteToString(byArray);
    }

    public String toString2() {
        return bw.byteToString(this.a);
    }

    public String toHexString() {
        StringBuffer stringBuffer = new StringBuffer(this.a.length * 4);
        int n2 = 0;
        while (n2 < this.a.length) {
            stringBuffer.append("0x");
            int n3 = this.a[n2] & 0xFF;
            if (n3 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n3, 16).toUpperCase());
            if (n2 < this.a.length - 1) {
                stringBuffer.append(' ');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public SnmpDataType copy() {
        return new SnmpOctetString(this);
    }

    public byte[] getValue() {
        return this.a;
    }

    public void setValue(byte[] byArray) {
        this.a = byArray;
    }

    public int encode(bc bc2) throws SnmpEncodingException {
        return bc2.a(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof SnmpOctetString)) {
            return false;
        }
        byte[] byArray = ((SnmpOctetString)object).a;
        int n2 = 0;
        while (n2 < this.a.length) {
            if (this.a[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.a == null) {
            return n2;
        }
        int n3 = 0;
        while (n3 < this.a.length) {
            n2 = 31 * n2 + this.a[n3];
            ++n3;
        }
        return n2;
    }

    public static byte[] getBytes(String string) {
        String string2 = bw.replaceString(string, "0x", "");
        String[] stringArray = cd.parse(string2, ' ', true);
        byte[] byArray = new byte[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            byArray[n2] = (byte)Integer.parseInt(stringArray[n2], 16);
            ++n2;
        }
        return byArray;
    }

    public static String convertPhysAddress(String string) {
        try {
            String string2;
            int n2;
            string = string.trim().toUpperCase();
            byte[] byArray = new byte[string.length()];
            int n3 = 0;
            int n4 = 0;
            while (n4 < string.length()) {
                n2 = string.charAt(n4);
                if (n2 <= 57 && n2 >= 48 || n2 <= 70 && n2 >= 65) {
                    byArray[n3++] = (byte)n2;
                }
                ++n4;
            }
            n2 = n3 / 2;
            byte[] byArray2 = new byte[n2];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                string2 = new String(byArray, n6, 2, "ISO-8859-1");
                int n7 = Integer.parseInt(string2, 16);
                byArray2[n5++] = (byte)n7;
                n6 += 2;
            }
            string2 = new String(byArray2, 0, n2, "ISO-8859-1");
            return string2;
        }
        catch (Exception exception) {
            Logger.error(exception);
            return "";
        }
    }
}

