/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpDecodingException;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.VarBindContainer;
import com.ireasoning.protocol.snmp.bb;
import com.ireasoning.protocol.snmp.bc;
import com.ireasoning.util.bw;
import com.ireasoning.util.ce;
import java.util.Random;

public class SnmpPdu
extends VarBindContainer
implements SnmpDataType {
    static int c = 0;
    int d;
    String e = "public";
    int f;
    int g;
    String h;
    boolean i = true;
    boolean j = false;
    static final String[] k = new String[]{"No Error", "Too Big", "No Such Name", "Bad Value", "Read Only", "General Error", "No Access", "Wrong Type", "Wrong Length", "Wrong Encoding", "Wrong Value", "No Creation", "Inconsistent Value", "Resource Unavailable", "Commit Failed", "Undo Failed", "Authorization Error", "Not Writable", "Inconsistent Name"};
    int l;
    int m;
    String n;
    byte[] o;
    boolean p = false;

    SnmpPdu() {
        this.f = 0;
        this.b();
        this.l = 0;
        this.m = 0;
    }

    public SnmpPdu(SnmpPdu snmpPdu) {
        super(snmpPdu);
        this.d = snmpPdu.d;
        this.e = bw.cloneString(snmpPdu.e);
        this.f = snmpPdu.f;
        this.g = snmpPdu.g;
        this.l = snmpPdu.l;
        this.m = snmpPdu.m;
        this.o = ce.cloneArray(snmpPdu.o);
        this.n = bw.cloneString(snmpPdu.n);
        this.p = snmpPdu.p;
    }

    public SnmpPdu(int n2) {
        this();
        this.f = n2;
    }

    public SnmpPdu(int n2, SnmpVarBind[] snmpVarBindArray) {
        this(n2);
        if (snmpVarBindArray != null) {
            this.a.ensureCapacity(snmpVarBindArray.length);
            int n3 = 0;
            while (n3 < snmpVarBindArray.length) {
                SnmpVarBind snmpVarBind = snmpVarBindArray[n3];
                this.addVarBind(new SnmpVarBind(snmpVarBind));
                ++n3;
            }
        }
    }

    public SnmpPdu(int n2, SnmpVarBind[] snmpVarBindArray, int n3) {
        this(n2, snmpVarBindArray);
        this.g = n3;
    }

    public static SnmpPdu decodePdu(byte[] byArray, int n2) throws SnmpDecodingException {
        bb bb2 = new bb(byArray, n2);
        int n3 = bb.getSnmpVersion(byArray, n2);
        if (n3 != 0 && n3 != 1) {
            return null;
        }
        SnmpPdu snmpPdu = (SnmpPdu)bb2.a(false);
        return snmpPdu;
    }

    public static byte[] encodePdu(SnmpPdu snmpPdu) throws SnmpEncodingException {
        bc bc2 = new bc();
        bc2.a(snmpPdu, snmpPdu.getVersion(), snmpPdu.getCommunity(), snmpPdu.getCommunity());
        byte[] byArray = bc2.a();
        int n2 = bc2.b();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public boolean hasMore() {
        return !this.a() && this.i;
    }

    public void setHasMore(boolean bl2) {
        this.i = bl2;
    }

    private boolean a() {
        return this.l != 0 || this.p || this.j;
    }

    synchronized void b() {
        if (c == 0) {
            Random random = new Random(System.currentTimeMillis());
            c = random.nextInt();
        }
        if (++c > 65535 || c < 0) {
            if (c < 0) {
                c = -c;
            }
            c %= 65535;
        }
        this.g = c;
    }

    public void setCommand(int n2) {
        this.f = n2;
    }

    public int getRequestID() {
        return this.g;
    }

    public void setRequestID(int n2) {
        this.g = n2;
    }

    public void setOID(String string) {
        this.setOID(new SnmpOID(string));
    }

    public void setOID(SnmpOID snmpOID) {
        this.removeAllVarBinds();
        SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOID);
        this.addVarBind(snmpVarBind);
        this.b();
    }

    public void setOIDs(String[] stringArray) {
        SnmpOID[] snmpOIDArray = new SnmpOID[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            snmpOIDArray[n2] = new SnmpOID(stringArray[n2]);
            ++n2;
        }
        this.setOIDs(snmpOIDArray);
    }

    public void setOIDs(SnmpOID[] snmpOIDArray) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpOIDArray.length];
        int n2 = 0;
        while (n2 < snmpVarBindArray.length) {
            snmpVarBindArray[n2] = new SnmpVarBind(snmpOIDArray[n2]);
            ++n2;
        }
        this.setVarBinds(snmpVarBindArray);
        this.b();
    }

    public int getCommand() {
        return (byte)(this.f & 0xFF);
    }

    public int getType() {
        return 320;
    }

    public String getTypeString() {
        return "PDU";
    }

    public int getVersion() {
        return this.d;
    }

    public void setVersion(int n2) {
        this.d = n2;
    }

    public String getCommunity() {
        return this.e;
    }

    public void setCommunity(String string) {
        this.e = string;
    }

    public String getErrorString() {
        if (this.j) {
            return "Authentication failure";
        }
        return this.getErrorStatusString();
    }

    public String getErrorStatusString() {
        return SnmpPdu.getErrorStatusString(this.l);
    }

    public static String getErrorStatusString(int n2) {
        if (n2 >= 0 && n2 < k.length) {
            return k[n2];
        }
        return k[5];
    }

    public int getErrorStatus() {
        return this.l;
    }

    public void setErrorStatus(int n2) {
        this.l = n2;
    }

    public int getErrorIndex() {
        return this.m;
    }

    public void setErrorIndex(int n2) {
        this.m = n2;
    }

    public int getNonRepeaters() {
        return this.l;
    }

    public void setNonRepeaters(int n2) {
        this.l = n2;
    }

    public int getMaxRepetitions() {
        return this.m;
    }

    public void setMaxRepetitions(int n2) {
        this.m = n2;
    }

    public String getContextName() {
        return this.n;
    }

    public void setContextName(String string) {
        this.n = string;
    }

    public byte[] getContextEngineID() {
        return this.o;
    }

    public void setContextEngineID(byte[] byArray) {
        this.o = byArray;
    }

    public String getIpAddress() {
        return this.h;
    }

    public void setIpAddress(String string) {
        this.h = string;
    }

    public String toString() {
        return "SNMP version:" + this.getVersion() + "; SNMP command:" + this.getCommand() + "; Community:" + this.getCommunity();
    }

    public SnmpDataType copy() {
        return new SnmpPdu(this);
    }

    public int encode(bc bc2) throws SnmpEncodingException {
        return bc2.a(this);
    }

    static int b(int n2) {
        if (n2 == 7 || n2 == 9 || n2 == 10 || n2 == 8 || n2 == 12) {
            return 3;
        }
        if (n2 == 17 || n2 == 6 || n2 == 11 || n2 == 18 || n2 == 16) {
            return 2;
        }
        return 5;
    }
}

