/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.BasicOIDTreeNode;
import com.ireasoning.protocol.snmp.OIDTreeNode;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpTableEntry;
import com.ireasoning.protocol.snmp.SnmpTableMBean;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class SnmpTable
implements SnmpTableMBean {
    protected OIDTreeNode _tableNode;
    protected Vector _rows = new Vector();
    protected long _updateInterval = -1L;
    protected long _lastUpdateTime = -1L;
    boolean a;

    public SnmpTable(OIDTreeNode oIDTreeNode, String string) {
        this._tableNode = (OIDTreeNode)oIDTreeNode.search(new SnmpOID(string));
        this._tableNode.k = this;
        this._tableNode.setRegistered(true);
        if (this._updateInterval > 0L) {
            this._lastUpdateTime = System.currentTimeMillis();
        }
    }

    public OIDTreeNode getTableNode() {
        return this._tableNode;
    }

    public void setTableNode(OIDTreeNode oIDTreeNode) {
        this._tableNode = oIDTreeNode;
    }

    public abstract SnmpTableEntry newEntryInstance();

    public ArrayList addRow(SnmpTableEntry snmpTableEntry, String string) {
        ArrayList<BasicOIDTreeNode> arrayList = new ArrayList<BasicOIDTreeNode>();
        if (string == null) {
            return arrayList;
        }
        if (!this.preAddRow(snmpTableEntry)) {
            return arrayList;
        }
        BasicOIDTreeNode basicOIDTreeNode = (BasicOIDTreeNode)this._tableNode.getFirstChild().getFirstChild();
        while (basicOIDTreeNode != null) {
            BasicOIDTreeNode basicOIDTreeNode2 = new BasicOIDTreeNode(new SnmpOID(basicOIDTreeNode.getName().toString() + string));
            BasicOIDTreeNode basicOIDTreeNode3 = (BasicOIDTreeNode)basicOIDTreeNode.addChild(basicOIDTreeNode2);
            basicOIDTreeNode3.setTableEntryObject(snmpTableEntry);
            basicOIDTreeNode = (BasicOIDTreeNode)basicOIDTreeNode.getNextSibling();
            arrayList.add(basicOIDTreeNode2);
        }
        this._rows.add(snmpTableEntry);
        this.postAddRow(snmpTableEntry);
        return arrayList;
    }

    public ArrayList addRow(SnmpTableEntry snmpTableEntry) {
        String string = snmpTableEntry.getIndexSuffix();
        return this.addRow(snmpTableEntry, string);
    }

    public ArrayList addRow(Collection collection) {
        if (collection == null) {
            return new ArrayList();
        }
        try {
            OIDTreeNode oIDTreeNode = (OIDTreeNode)this._tableNode.getFirstChild().getFirstChild();
            SnmpTableEntry snmpTableEntry = this.newEntryInstance();
            String string = null;
            int n2 = 0;
            while (oIDTreeNode != null) {
                SnmpOID snmpOID = (SnmpOID)oIDTreeNode.getName();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    SnmpOID snmpOID2;
                    SnmpVarBind snmpVarBind = (SnmpVarBind)iterator.next();
                    if (snmpVarBind == null || !(snmpOID2 = snmpVarBind.getName()).startsWith(snmpOID)) continue;
                    if (string == null) {
                        string = snmpOID2.suboid(snmpOID.getLength(), snmpOID2.getLength()).toString();
                    }
                    snmpTableEntry.set(n2, snmpVarBind.getValue());
                }
                oIDTreeNode = (OIDTreeNode)oIDTreeNode.getNextSibling();
                ++n2;
            }
            if (string != null) {
                snmpTableEntry.setIndexSuffix(string);
            }
            return this.addRow(snmpTableEntry);
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    public ArrayList deleteRow(int n2) {
        if (n2 >= this._rows.size() || n2 < 0) {
            return new ArrayList();
        }
        return this.deleteRow((SnmpTableEntry)this._rows.get(n2));
    }

    public ArrayList deleteRow(String string) {
        SnmpTableEntry snmpTableEntry;
        int n2 = this._rows.size();
        int n3 = 0;
        while (n3 < n2) {
            snmpTableEntry = (SnmpTableEntry)this._rows.get(n3);
            String string2 = snmpTableEntry.getIndexSuffix();
            if (string2.equals(string)) {
                return this.deleteRow(snmpTableEntry);
            }
            ++n3;
        }
        snmpTableEntry = null;
        return this.deleteRow(snmpTableEntry);
    }

    public ArrayList deleteRow(SnmpTableEntry snmpTableEntry) {
        ArrayList arrayList = new ArrayList();
        if (snmpTableEntry == null) {
            return arrayList;
        }
        if (!this.preDeleteRow(snmpTableEntry)) {
            return arrayList;
        }
        boolean bl2 = this._rows.remove(snmpTableEntry);
        if (!bl2) {
            return arrayList;
        }
        String string = snmpTableEntry.getIndexSuffix();
        arrayList = this.a(string);
        ArrayList arrayList2 = snmpTableEntry.deleteDependentRows();
        arrayList.addAll(arrayList2);
        this.postDeleteRow(snmpTableEntry);
        return arrayList;
    }

    public void deleteAllRows() {
        Vector vector = new Vector(this._rows.size());
        vector.addAll(this._rows);
        int n2 = 0;
        while (n2 < vector.size()) {
            this.deleteRow((SnmpTableEntry)vector.get(n2));
            ++n2;
        }
    }

    public String getIndexSuffix(int n2) {
        this.a(n2);
        SnmpTableEntry snmpTableEntry = (SnmpTableEntry)this._rows.get(n2);
        return snmpTableEntry.getIndexSuffix();
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public int getColumnCount() {
        return this._tableNode.getFirstChild().getChildNodeCount();
    }

    public Vector getRows() {
        return this._rows;
    }

    public SnmpTableEntry getRow(int n2) {
        this.a(n2);
        return (SnmpTableEntry)this._rows.get(n2);
    }

    public SnmpTableEntry getRow(String string) {
        int n2 = this._rows.size();
        int n3 = 0;
        while (n3 < n2) {
            SnmpTableEntry snmpTableEntry = (SnmpTableEntry)this._rows.get(n3);
            String string2 = snmpTableEntry.getIndexSuffix();
            if (string2.equals(string)) {
                return snmpTableEntry;
            }
            ++n3;
        }
        return null;
    }

    public boolean isTimeToUpdate() {
        if (this._updateInterval < 0L) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - this._lastUpdateTime > this._updateInterval) {
            this._lastUpdateTime = l2;
            return true;
        }
        return false;
    }

    public void update() {
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public void setUpdateInterval(long l2) {
        this._updateInterval = l2;
    }

    public long getUpdateInterval() {
        return this._updateInterval;
    }

    private ArrayList a(String string) {
        OIDTreeNode oIDTreeNode = (OIDTreeNode)this._tableNode.getFirstChild().getFirstChild();
        ArrayList<SnmpOID> arrayList = new ArrayList<SnmpOID>();
        boolean bl2 = true;
        while (oIDTreeNode != null) {
            SnmpOID snmpOID = new SnmpOID(oIDTreeNode.getName().toString() + string);
            if (oIDTreeNode.removeChild(snmpOID)) {
                arrayList.add(snmpOID);
            }
            oIDTreeNode = (OIDTreeNode)oIDTreeNode.getNextSibling();
        }
        return arrayList;
    }

    private void a(int n2) {
        if (n2 >= this._rows.size() || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this._rows.size());
        }
    }

    public boolean preAddRow(SnmpTableEntry snmpTableEntry) {
        return true;
    }

    public void postAddRow(SnmpTableEntry snmpTableEntry) {
    }

    public boolean preDeleteRow(SnmpTableEntry snmpTableEntry) {
        return true;
    }

    public void postDeleteRow(SnmpTableEntry snmpTableEntry) {
    }

    public void preSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, SnmpPdu snmpPdu) {
    }

    public boolean preSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, Collection collection) {
        return true;
    }

    public void postSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, SnmpPdu snmpPdu) {
    }

    public void postSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, Collection collection) {
    }

    public void setProcessSnmpRequestDirectly(boolean bl2) {
        this.a = bl2;
    }

    public boolean isProcessSnmpRequestDirectly() {
        return this.a;
    }

    public SnmpTableEntry getNextOID(SnmpOID snmpOID) {
        return null;
    }

    public SnmpTableEntry getOID(SnmpOID snmpOID) {
        return null;
    }

    public ArrayList getColumnOIDs() {
        ArrayList<SnmpOID> arrayList = new ArrayList<SnmpOID>();
        OIDTreeNode oIDTreeNode = (OIDTreeNode)this._tableNode.getFirstChild().getFirstChild();
        while (oIDTreeNode != null) {
            arrayList.add((SnmpOID)oIDTreeNode.getName());
            oIDTreeNode = (OIDTreeNode)oIDTreeNode.getNextSibling();
        }
        return arrayList;
    }
}

