/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpDecodingException;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpIpAddress;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.SnmpTrap;
import com.ireasoning.protocol.snmp.SnmpV2Notification;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.VarBindContainer;
import com.ireasoning.protocol.snmp.bb;
import com.ireasoning.protocol.snmp.bc;
import com.ireasoning.util.Logger;
import com.ireasoning.util.bw;
import com.ireasoning.util.cc;
import com.ireasoning.util.r;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpV1Trap
extends VarBindContainer
implements SnmpDataType {
    SnmpOID c;
    SnmpIpAddress d;
    int e = 0;
    int f = 0;
    long g = 0L;
    String h;
    static r i = new r();
    public static final int COLD_START_TRAP = 0;
    public static final int WARM_START_TRAP = 1;
    public static final int LINK_DOWN_TRAP = 2;
    public static final int LINK_UP_TRAP = 3;
    public static final int AUTHENTICATION_FAILURE_TRAP = 4;
    public static final int EGPNEIGHBOR_LOSS_TRAP = 5;
    private static final String[] j;
    static final SnmpOID k;
    static final SnmpOID l;
    static final SnmpOID[] m;

    SnmpV1Trap() {
        try {
            this.d = new SnmpIpAddress(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            Logger.error(unknownHostException);
        }
    }

    public SnmpV1Trap(SnmpOID snmpOID) {
        this();
        this.c = new SnmpOID(snmpOID);
    }

    public SnmpV1Trap(String string) {
        this(new SnmpOID(string));
    }

    public SnmpV1Trap(SnmpV1Trap snmpV1Trap) {
        super(snmpV1Trap);
        this.c = snmpV1Trap.c;
        this.d = snmpV1Trap.d;
        this.e = snmpV1Trap.e;
        this.f = snmpV1Trap.f;
        this.g = snmpV1Trap.g;
        this.h = bw.cloneString(snmpV1Trap.h);
    }

    public static SnmpV1Trap decodeV1Trap(byte[] byArray, int n2) throws SnmpDecodingException {
        bb bb2 = new bb(byArray, n2);
        SnmpV1Trap snmpV1Trap = (SnmpV1Trap)bb2.a(false);
        return snmpV1Trap;
    }

    public static byte[] encodeV1Trap(SnmpV1Trap snmpV1Trap) throws SnmpEncodingException {
        bc bc2 = new bc();
        bc2.a(snmpV1Trap, snmpV1Trap.getCommunity());
        byte[] byArray = bc2.a();
        int n2 = bc2.b();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public SnmpOID getEnterprise() {
        return this.c;
    }

    public void setEnterprise(SnmpOID snmpOID) {
        this.c = new SnmpOID(snmpOID);
    }

    public void setEnterprise(String string) {
        this.c = new SnmpOID(string);
    }

    public SnmpIpAddress getIpAddress() {
        return this.d;
    }

    public SnmpIpAddress getAgentIpAddress() {
        return this.d;
    }

    public void setIpAddress(SnmpIpAddress snmpIpAddress) {
        this.d = snmpIpAddress;
    }

    public void setIpAddress(String string) {
        this.d = new SnmpIpAddress(string);
    }

    public void setIpAddress(InetAddress inetAddress) {
        this.d = new SnmpIpAddress(inetAddress.getHostAddress());
    }

    public int getGeneric() {
        return this.e;
    }

    public String getGenericString() {
        if (this.e < 0 || this.e >= j.length) {
            return null;
        }
        return j[this.e];
    }

    public void setGeneric(int n2) {
        this.e = n2;
        if (this.e < 6) {
            this.f = 0;
        }
    }

    public int getSpecific() {
        return this.f;
    }

    public void setSpecific(int n2) {
        this.f = n2;
        this.e = 6;
    }

    public long getTimestamp() {
        return this.g;
    }

    public void setTimestamp(long l2) {
        this.g = l2;
    }

    public String getTimestampString() {
        return "" + new cc(this.g * 10L);
    }

    public String getCommunity() {
        return this.h;
    }

    public void setCommunity(String string) {
        this.h = string;
    }

    public SnmpVarBind[] getVariables() {
        return this.getVarBinds();
    }

    public int getType() {
        return -92;
    }

    public String getTypeString() {
        return "V1Trap";
    }

    public SnmpTrap toV2Trap() {
        return this.toV2Trap(false);
    }

    public SnmpTrap toV2Trap(boolean bl2) {
        Object object;
        long l2 = this.g;
        SnmpOID snmpOID = null;
        if (this.e == 6) {
            snmpOID = new SnmpOID(this.c);
            object = new long[]{0L, this.f};
            snmpOID.append((long[])object);
        } else {
            snmpOID = new SnmpOID((SnmpOID)i.get(this.e));
        }
        object = new SnmpTrap(l2, snmpOID, this.a.toArray());
        if (bl2) {
            boolean[] blArray = new boolean[3];
            int n2 = 0;
            while (n2 < this.a.size()) {
                SnmpVarBind snmpVarBind = this.a.get(n2);
                int n3 = 0;
                while (n3 < 3) {
                    if (snmpVarBind.getName().equals(m[n3])) {
                        blArray[n3] = true;
                    }
                    ++n3;
                }
                ++n2;
            }
            int n4 = 0;
            while (n4 < 3) {
                if (!blArray[n4]) {
                    SnmpDataType snmpDataType = null;
                    if (n4 == 0) {
                        snmpDataType = this.d;
                    } else if (n4 == 1) {
                        snmpDataType = new SnmpOctetString(this.h);
                    } else if (n4 == 2) {
                        snmpDataType = this.c;
                    }
                    SnmpVarBind snmpVarBind = new SnmpVarBind(new SnmpOID(m[n4]), snmpDataType);
                    object.addVarBind(snmpVarBind);
                }
                ++n4;
            }
        }
        object.setIpAddress(this.d.toString());
        return object;
    }

    public SnmpDataType copy() {
        return new SnmpV1Trap(this);
    }

    public int encode(bc bc2) throws SnmpEncodingException {
        return bc2.a(this);
    }

    public String toString() {
        String string = "";
        string = string + "Community:\t\t" + bw.convertNull(this.h) + "\r\n";
        string = string + "Enterprise OID:\t\t" + this.getEnterprise() + "\r\n";
        string = string + "Ip Address:\t\t" + this.getIpAddress() + "\r\n";
        string = string + "Generic:\t\t" + this.getGenericString() + "\r\n";
        string = string + "Specific:\t\t" + this.getSpecific() + "\r\n";
        string = string + "TimeStamp:\t\t" + this.getTimestampString() + "\r\n";
        int n2 = this.getVarBindCount();
        int n3 = 0;
        while (n3 < n2) {
            SnmpVarBind snmpVarBind = this.getVarBind(n3);
            string = string + snmpVarBind.toString() + "\r\n";
            ++n3;
        }
        return string;
    }

    static {
        i.put(0, SnmpV2Notification.COLD_START_TRAP_OID);
        i.put(1, SnmpV2Notification.WARM_START_TRAP_OID);
        i.put(2, SnmpV2Notification.LINK_DOWN_TRAP_OID);
        i.put(3, SnmpV2Notification.LINK_UP_TRAP_OID);
        i.put(4, SnmpV2Notification.AUTHENTICATION_FAILURE_TRAP_OID);
        i.put(5, SnmpV2Notification.EGPNEIGHBOR_LOSS_OID);
        j = new String[]{"coldStart", "warmStart", "linkDown", "linkUp", "authenticationFailure", "egpNeighborLoss", "enterpriseSpecific"};
        k = new SnmpOID(".1.3.6.1.6.3.18.1.3.0");
        l = new SnmpOID(".1.3.6.1.6.3.18.1.4.0");
        m = new SnmpOID[]{k, l, SnmpV2Notification.SNMP_TRAP_ENTERPRISE_OID};
    }
}

