/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpTimeTicks;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.bw;
import java.net.InetAddress;

public abstract class SnmpV2Notification
extends SnmpPdu {
    public static final SnmpOID SYS_UP_TIME_OID = new SnmpOID(".1.3.6.1.2.1.1.3.0");
    public static final SnmpOID SNMP_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.4.1.0");
    public static final SnmpOID SNMP_TRAP_ENTERPRISE_OID = new SnmpOID(".1.3.6.1.6.3.1.1.4.3.0");
    public static final SnmpOID COLD_START_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.1");
    public static final SnmpOID WARM_START_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.2");
    public static final SnmpOID LINK_DOWN_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.3");
    public static final SnmpOID LINK_UP_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.4");
    public static final SnmpOID AUTHENTICATION_FAILURE_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.5");
    public static final SnmpOID EGPNEIGHBOR_LOSS_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.6");

    SnmpV2Notification() {
    }

    public SnmpV2Notification(long l2, SnmpOID snmpOID, SnmpVarBind[] snmpVarBindArray) {
        this();
        this.removeAllVarBinds();
        SnmpTimeTicks snmpTimeTicks = new SnmpTimeTicks(l2);
        SnmpVarBind snmpVarBind = new SnmpVarBind(SYS_UP_TIME_OID, (SnmpDataType)snmpTimeTicks);
        this.addVarBind(snmpVarBind);
        snmpVarBind = new SnmpVarBind(SNMP_TRAP_OID, (SnmpDataType)snmpOID);
        this.addVarBind(snmpVarBind);
        this.addVarBinds(snmpVarBindArray);
    }

    public SnmpV2Notification(long l2, SnmpOID snmpOID) {
        this(l2, snmpOID, null);
    }

    public SnmpV2Notification(SnmpV2Notification snmpV2Notification) {
        super(snmpV2Notification);
    }

    public long getSysUpTime() {
        SnmpVarBind snmpVarBind = this.a.get(0);
        SnmpTimeTicks snmpTimeTicks = (SnmpTimeTicks)snmpVarBind.getValue();
        return snmpTimeTicks.getValue();
    }

    public void setSysUpTime(long l2) {
        SnmpVarBind snmpVarBind = this.a.get(0);
        snmpVarBind.setValue(new SnmpTimeTicks(l2));
    }

    public String getSysUpTimeString() {
        SnmpVarBind snmpVarBind = this.a.get(0);
        SnmpTimeTicks snmpTimeTicks = (SnmpTimeTicks)snmpVarBind.getValue();
        return snmpTimeTicks.getTimeString();
    }

    public SnmpOID getSnmpTrapOID() {
        SnmpVarBind snmpVarBind = this.a.get(1);
        return (SnmpOID)snmpVarBind.getValue();
    }

    public SnmpVarBind[] getObjects() {
        int n2 = this.a.size() - 2;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        int n3 = 0;
        while (n3 < n2) {
            snmpVarBindArray[n3] = this.a.get(n3 + 2);
            ++n3;
        }
        return snmpVarBindArray;
    }

    public String getIpAddress() {
        return this.h;
    }

    public void setIpAddress(String string) {
        this.h = string;
    }

    public void setIpAddress(InetAddress inetAddress) {
        this.h = inetAddress.getHostAddress();
    }

    public String toString() {
        String string = "";
        string = string + "Community:\t\t" + bw.convertNull(this.e) + "\r\n";
        string = string + "sysUpTime.0:\t\t" + this.getSysUpTimeString() + "\r\n";
        string = string + "snmpTrapOID.0:\t\t" + this.getSnmpTrapOID() + "\r\n";
        if (this.getVarBindCount() > 2) {
            SnmpVarBind[] snmpVarBindArray = this.getObjects();
            int n2 = 0;
            while (n2 < snmpVarBindArray.length) {
                string = string + snmpVarBindArray[n2].toString() + "\r\n";
                ++n2;
            }
        }
        return string;
    }
}

