/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public final class FileDEncryption {
    private String inputFile;
    private String outputFile;
    private Key secretKey;
    private String keyfile;
    private String alg;
    private boolean running_enc;
    private String provider;
    private String mode;
    private byte[] iv;

    public FileDEncryption(String string, Key key, byte[] byArray, String string2, String string3, String string4, String string5) {
        this.inputFile = string;
        this.outputFile = String.valueOf(string) + "." + string2 + "." + string3 + "." + string4;
        this.alg = String.valueOf(string2) + "/" + string3 + "/" + string4;
        this.mode = string3;
        this.secretKey = key;
        this.iv = byArray;
        this.keyfile = String.valueOf(this.outputFile) + "." + "key";
        this.provider = string5;
    }

    private boolean ciphering(int n2) {
        boolean bl2 = false;
        boolean bl3 = false;
        IvParameterSpec ivParameterSpec = null;
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.alg, this.provider);
            if (this.mode == "ECB") {
                cipher.init(n2, this.secretKey);
            } else {
                ivParameterSpec = new IvParameterSpec(this.iv);
                cipher.init(n2, this.secretKey, ivParameterSpec);
            }
            bl3 = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            invalidAlgorithmParameterException.printStackTrace();
        }
        if (!bl3) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        CipherOutputStream cipherOutputStream = null;
        try {
            if (this.running_enc) {
                fileInputStream = new FileInputStream(this.inputFile);
                fileOutputStream = new FileOutputStream(String.valueOf(this.outputFile) + ".encrypted");
                cipherOutputStream = new CipherOutputStream(fileOutputStream, cipher);
                byte[] byArray = new byte[8192];
                int n3 = 0;
                while ((n3 = fileInputStream.read(byArray)) != -1) {
                    cipherOutputStream.write(byArray, 0, n3);
                }
                fileInputStream.close();
                cipherOutputStream.close();
            } else {
                CipherInputStream cipherInputStream = null;
                fileInputStream = new FileInputStream(String.valueOf(this.outputFile) + ".encrypted");
                cipherInputStream = new CipherInputStream(fileInputStream, cipher);
                fileOutputStream = new FileOutputStream(String.valueOf(this.outputFile) + ".decrypted");
                byte[] byArray = new byte[8192];
                int n4 = 0;
                while ((n4 = cipherInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n4);
                }
                cipherInputStream.close();
                fileOutputStream.close();
            }
            bl2 = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found! " + fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("IOException! " + iOException.getMessage());
            iOException.printStackTrace();
        }
        return bl2;
    }

    private boolean getKeyWithIV() {
        boolean bl2 = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.keyfile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.secretKey = (Key)objectInputStream.readObject();
            this.iv = new byte[fileInputStream.available()];
            fileInputStream.read(this.iv);
            objectInputStream.close();
            System.out.println("Read key!\n");
            bl2 = true;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            streamCorruptedException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (OptionalDataException optionalDataException) {
            optionalDataException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl2;
    }

    public final synchronized boolean go() {
        this.running_enc = true;
        boolean bl2 = this.saveKeyWithIV();
        bl2 = bl2 ? this.ciphering(1) : (bl2 ^= true);
        return bl2;
    }

    public final synchronized boolean reTurn() {
        this.running_enc = false;
        boolean bl2 = this.getKeyWithIV();
        bl2 = bl2 ? this.ciphering(2) : (bl2 ^= true);
        return bl2;
    }

    private boolean saveKeyWithIV() {
        boolean bl2 = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.keyfile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.secretKey);
            if (this.mode != "ECB") {
                fileOutputStream.write(this.iv);
            }
            objectOutputStream.close();
            fileOutputStream.close();
            bl2 = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found!\n");
        }
        catch (IOException iOException) {
            System.out.println("IOException!\n");
        }
        return bl2;
    }
}

