/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import cryptix.jce.examples.FileHashing;
import cryptix.jce.examples.SymmetricCipher;
import cryptix.jce.provider.CryptixCrypto;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Security;

public final class RunSamples {
    private static boolean addProviderCryptix() {
        CryptixCrypto cryptixCrypto = new CryptixCrypto();
        int n2 = Security.addProvider(cryptixCrypto);
        if (n2 == -1) {
            System.out.println("Provider entry already in file.\n");
            return false;
        }
        System.out.println("Provider added at position: " + n2);
        return true;
    }

    public static void main(String[] stringArray) {
        Object object;
        FileInputStream fileInputStream = null;
        String string = null;
        if (stringArray.length < 1) {
            System.out.println("You did not specify a file to encrypt!?");
            System.out.println("If you want one to encrypt just place a filename as first argument to the program.");
        } else {
            try {
                fileInputStream = new FileInputStream(stringArray[0]);
                fileInputStream.close();
                string = stringArray[0];
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Filename is not valid!");
                fileNotFoundException.printStackTrace();
                System.exit(-1);
            }
            catch (IOException iOException) {
                System.out.println("IO Error!");
                iOException.printStackTrace();
                System.exit(-1);
            }
        }
        if (!RunSamples.addProviderCryptix()) {
            System.out.println("Could not add provider cryptix.\n");
            System.exit(-1);
        }
        String string2 = "CryptixCrypto";
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = new String[]{"ECB", "CBC", "OFB"};
        String[] stringArray4 = new String[]{"None", "NoPadding", "PKCS#5"};
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        while (n2 < stringArray2.length) {
            n3 = 0;
            while (n3 < stringArray3.length) {
                n4 = 0;
                while (n4 < stringArray4.length) {
                    System.out.println("***************\nNew cipher object!");
                    System.out.println("Using:" + stringArray2[n2] + "/" + stringArray3[n3] + "/" + stringArray4[n4] + "\n");
                    object = new SymmetricCipher();
                    ((SymmetricCipher)object).run(stringArray2[n2], stringArray3[n3], stringArray4[n4], string2, string);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        System.out.println("**************\nRunning hash functions:");
        object = new String[]{"MD2", "MD4", "MD5", "RIPEMD128", "RIPEMD160", "SHA", "SHA0", "SHA1"};
        if (string != null) {
            int n5 = 0;
            while (n5 < ((String[])object).length) {
                System.out.println("***************");
                System.out.println("New hash object.");
                System.out.println("Using: " + (String)object[n5] + "/" + string2);
                FileHashing fileHashing = new FileHashing();
                fileHashing.run((String)object[n5], string2, string);
                ++n5;
            }
        } else {
            System.out.println("You did not provide any file to hash.");
        }
        System.out.println("**************");
        System.out.println();
    }
}

