/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public final class AsnInteger
extends AsnObject {
    private final BigInteger val;

    AsnInteger(AsnInputStream asnInputStream) throws IOException {
        super((byte)2);
        int n2 = asnInputStream.readLength();
        byte[] byArray = asnInputStream.readBytes(n2);
        this.val = new BigInteger(byArray);
    }

    public AsnInteger(BigInteger bigInteger) {
        super((byte)2);
        this.val = bigInteger;
    }

    protected void encodePayload(AsnOutputStream asnOutputStream) throws IOException {
        asnOutputStream.writeBytes(this.val.toByteArray());
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream asnOutputStream) {
        return this.val.toByteArray().length;
    }

    public BigInteger toBigInteger() {
        return this.val;
    }

    public String toString(String string) {
        return String.valueOf(string) + "BIGINTEGER (" + this.val.toString() + ")";
    }
}

