/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;

public abstract class AsnObject {
    static final byte TAG_MASK = 31;
    static final byte TAG_INTEGER = 2;
    static final byte TAG_BITSTRING = 3;
    static final byte TAG_NULL = 5;
    static final byte TAG_OBJECT_ID = 6;
    static final byte TAG_SEQUENCE = 48;
    static final byte TAG_SET = 49;
    static final byte TAG_PRINTABLE_STRING = 19;
    static final byte TAG_UTCTime = 23;
    private final byte tag;

    protected AsnObject(byte by2) {
        this.tag = by2;
    }

    final void encode(AsnOutputStream asnOutputStream) throws IOException {
        asnOutputStream.writeType(this.tag);
        asnOutputStream.writeLength(this.getEncodedLengthOfPayload(asnOutputStream));
        this.encodePayload(asnOutputStream);
    }

    protected abstract void encodePayload(AsnOutputStream var1) throws IOException;

    public final boolean equals(Object object) {
        throw new RuntimeException("AsnObject.equals(...) not implemented.");
    }

    final int getEncodedLength(AsnOutputStream asnOutputStream) {
        int n2 = this.getEncodedLengthOfPayload(asnOutputStream);
        n2 += asnOutputStream.getLengthOfLength(n2);
        return ++n2;
    }

    protected abstract int getEncodedLengthOfPayload(AsnOutputStream var1);

    final byte getTag() {
        return this.tag;
    }

    public final int hashCode() {
        throw new RuntimeException("AsnObject.hashCode(...) not implemented.");
    }

    public final String toString() {
        return this.toString("");
    }

    public abstract String toString(String var1);
}

