/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class AsnOutputStream {
    private final OutputStream os;

    public AsnOutputStream() {
        this.os = new ByteArrayOutputStream();
    }

    public AsnOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void close() throws IOException {
        this.os.flush();
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    int getLengthOfLength(int n2) {
        if (n2 <= 127) {
            return 1;
        }
        if (n2 <= 255) {
            return 2;
        }
        if (n2 <= 65535) {
            return 3;
        }
        if (n2 <= 0xFFFFFF) {
            return 4;
        }
        return 5;
    }

    public byte[] toByteArray() {
        if (!(this.os instanceof ByteArrayOutputStream)) {
            throw new IllegalStateException("Underlying stream is not instanceof ByteArrayOutputStream.");
        }
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.os;
        return byteArrayOutputStream.toByteArray();
    }

    public void write(AsnObject asnObject) throws IOException {
        asnObject.encode(this);
    }

    void writeByte(byte by2) throws IOException {
        this.os.write(by2 & 0xFF);
    }

    void writeBytes(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    void writeLength(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("len: < 0");
        }
        if (n2 <= 127) {
            this.os.write((char)n2);
            return;
        }
        int n3 = this.getLengthOfLength(n2) - 1;
        this.os.write((byte)(n3 | 0x80));
        while (n3-- > 0) {
            this.os.write((byte)(n2 >>> n3 * 8));
        }
    }

    void writeType(byte by2) throws IOException {
        this.os.write(by2);
    }
}

