/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;
import java.util.Vector;

public final class AsnSequence
extends AsnObject {
    private final AsnObject[] vals;

    AsnSequence(AsnInputStream asnInputStream) throws IOException {
        super((byte)48);
        int n2 = asnInputStream.readLength();
        AsnInputStream asnInputStream2 = asnInputStream.getSubStream(n2);
        Vector<AsnObject> vector = new Vector<AsnObject>(3);
        while (asnInputStream2.available() > 0) {
            vector.addElement(asnInputStream2.read());
        }
        this.vals = new AsnObject[vector.size()];
        vector.copyInto(this.vals);
    }

    public AsnSequence(AsnObject asnObject, AsnObject asnObject2) {
        super((byte)48);
        AsnObject[] asnObjectArray = new AsnObject[]{asnObject, asnObject2};
        this.vals = asnObjectArray;
    }

    public AsnSequence(AsnObject[] asnObjectArray) {
        super((byte)48);
        this.vals = (AsnObject[])asnObjectArray.clone();
    }

    protected void encodePayload(AsnOutputStream asnOutputStream) throws IOException {
        int n2 = 0;
        while (n2 < this.vals.length) {
            asnOutputStream.write(this.vals[n2]);
            ++n2;
        }
    }

    public AsnObject get(int n2) {
        return this.vals[n2];
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream asnOutputStream) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.vals.length) {
            n2 += this.vals[n3].getEncodedLength(asnOutputStream);
            ++n3;
        }
        return n2;
    }

    public int size() {
        return this.vals.length;
    }

    public String toString(String string) {
        String string2 = String.valueOf(string) + "SEQUENCE (" + this.vals.length + " elements):";
        int n2 = 0;
        while (n2 < this.vals.length) {
            string2 = String.valueOf(string2) + "\n" + this.vals[n2].toString(String.valueOf(string) + "    ");
            ++n2;
        }
        return string2;
    }
}

