/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.Mode;
import cryptix.jce.provider.cipher.Padding;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class BlockCipher
extends CipherSpi {
    private int state = 0;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_DECRYPT = 1;
    private static final int STATE_ENCRYPT = 2;
    private final int BLOCK_SIZE;
    private Key key;
    private String algorithm;
    private Padding padding;
    private Mode mode;

    protected BlockCipher(int n2) {
        this("", n2);
    }

    protected BlockCipher(String string, int n2) {
        this.BLOCK_SIZE = n2;
        this.algorithm = string;
        try {
            this.mode = Mode.getInstance("ECB", this);
            this.padding = Padding.getInstance("None", this.mode);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new InternalError("PANIC: Installation corrupt, default padding not available.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("PANIC: Installation corrupt, default mode not available.");
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    abstract void coreCrypt(byte[] var1, int var2, byte[] var3, int var4);

    int coreGetBlockSize() {
        return this.BLOCK_SIZE;
    }

    abstract void coreInit(Key var1, boolean var2) throws InvalidKeyException;

    protected final byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] byArray2 = new byte[this.engineGetOutputSize(n3)];
            int n4 = this.engineDoFinal(byArray, n2, n3, byArray2, 0);
            if (n4 != byArray2.length) {
                byte[] byArray3 = new byte[n4];
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
                byArray2 = byArray3;
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
    }

    protected final int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.padding.doFinal(byArray, n2, n3, byArray2, n4);
    }

    protected final int engineGetBlockSize() {
        return this.padding.getBlockSize();
    }

    protected final byte[] engineGetIV() {
        return this.padding.getIV();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new IllegalArgumentException("Key missing");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        return byArray.length * 8;
    }

    protected final int engineGetOutputSize(int n2) {
        return this.padding.getOutputSize(n2);
    }

    protected final AlgorithmParameters engineGetParameters() {
        AlgorithmParameterSpec algorithmParameterSpec = this.padding.getParamSpec();
        if (algorithmParameterSpec == null) {
            return null;
        }
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance(this.algorithm, "CryptixCrypto");
            algorithmParameters.init(algorithmParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
        return algorithmParameters;
    }

    protected final void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new RuntimeException("Not supported on this cipher.");
    }

    protected final void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        AlgorithmParameterSpec algorithmParameterSpec = this.padding.getParamSpec();
        try {
            this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalError("Unreachable code reached.");
        }
    }

    protected final void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        boolean bl2 = n2 == 2;
        this.padding.init(bl2, key, algorithmParameterSpec, secureRandom);
    }

    protected final void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.mode = Mode.getInstance(string, this);
    }

    protected final void engineSetPadding(String string) throws NoSuchPaddingException {
        this.padding = Padding.getInstance(string, this.mode);
    }

    protected final byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return null;
        }
        try {
            byte[] byArray2 = new byte[this.engineGetOutputSize(n3)];
            int n4 = this.engineUpdate(byArray, n2, n3, byArray2, 0);
            if (n4 != byArray2.length) {
                byte[] byArray3 = new byte[n4];
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
                byArray2 = byArray3;
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
    }

    protected final int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (n3 == 0) {
            return 0;
        }
        return this.padding.update(byArray, n2, n3, byArray2, n4);
    }
}

