/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class IDEA
extends BlockCipher {
    private static final int ROUNDS = 8;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 16;
    private static final int INTERNAL_KEY_LENGTH = 52;
    private short[] ks = new short[52];

    public IDEA() {
        super(8);
    }

    private void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        short s2;
        short s3 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s4 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s5 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s6 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF);
        int n4 = 0;
        int n5 = 8;
        while (n5-- > 0) {
            s3 = IDEA.mul(s3, this.ks[n4++]);
            s4 = (short)(s4 + this.ks[n4++]);
            s5 = (short)(s5 + this.ks[n4++]);
            s6 = IDEA.mul(s6, this.ks[n4++]);
            short s7 = s5;
            s5 = IDEA.mul(s3 ^ s5, this.ks[n4++]);
            s2 = s4;
            s4 = IDEA.mul(s5 + (s4 ^ s6), this.ks[n4++]);
            s5 = (short)(s5 + s4);
            s3 = (short)(s3 ^ s4);
            s6 = (short)(s6 ^ s5);
            s4 = (short)(s4 ^ s7);
            s5 = (short)(s5 ^ s2);
        }
        s2 = IDEA.mul(s3, this.ks[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s5 + this.ks[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s4 + this.ks[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = IDEA.mul(s6, this.ks[n4]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3] = (byte)s2;
    }

    protected void coreCrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.blockEncrypt(byArray, n2, byArray2, n3);
    }

    protected void coreInit(Key key, boolean bl2) throws InvalidKeyException {
        this.makeKey(key);
        if (bl2) {
            this.invertKey();
        }
    }

    private static short inv(short s2) {
        int n2 = s2 & 0xFFFF;
        if (n2 <= 1) {
            return (short)n2;
        }
        int n3 = 65537 / n2;
        int n4 = 65537 % n2;
        if (n4 == 1) {
            return (short)(1 - n3);
        }
        int n5 = 1;
        do {
            int n6 = n2 / n4;
            n5 += n6 * n3;
            if ((n2 %= n4) == 1) {
                return (short)n5;
            }
            n6 = n4 / n2;
            n3 += n6 * n5;
        } while ((n4 %= n2) != 1);
        return (short)(1 - n3);
    }

    private void invertKey() {
        int n2 = 4;
        int n3 = 51;
        short[] sArray = new short[52];
        sArray[n3--] = IDEA.inv(this.ks[3]);
        sArray[n3--] = -this.ks[2];
        sArray[n3--] = -this.ks[1];
        sArray[n3--] = IDEA.inv(this.ks[0]);
        int n4 = 1;
        while (n4 < 8) {
            sArray[n3--] = this.ks[n2 + 1];
            sArray[n3--] = this.ks[n2];
            sArray[n3--] = IDEA.inv(this.ks[n2 + 5]);
            sArray[n3--] = -this.ks[n2 + 3];
            sArray[n3--] = -this.ks[n2 + 4];
            sArray[n3--] = IDEA.inv(this.ks[n2 + 2]);
            ++n4;
            n2 += 6;
        }
        sArray[n3--] = this.ks[n2 + 1];
        sArray[n3--] = this.ks[n2];
        sArray[n3--] = IDEA.inv(this.ks[n2 + 5]);
        sArray[n3--] = -this.ks[n2 + 4];
        sArray[n3--] = -this.ks[n2 + 3];
        sArray[n3--] = IDEA.inv(this.ks[n2 + 2]);
        System.arraycopy(sArray, 0, this.ks, 0, 52);
    }

    private void makeKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.ks[0] = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.ks[1] = (short)((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        this.ks[2] = (short)((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
        this.ks[3] = (short)((byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF);
        this.ks[4] = (short)((byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF);
        this.ks[5] = (short)((byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF);
        this.ks[6] = (short)((byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF);
        this.ks[7] = (short)((byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF);
        int n2 = 0;
        int n3 = 0;
        int n4 = 8;
        while (n4 < 52) {
            this.ks[++n2 + 7 + n3] = (short)(this.ks[(n2 & 7) + n3] << 9 | this.ks[(n2 + 1 & 7) + n3] >>> 7 & 0x1FF);
            n3 += n2 & 8;
            n2 &= 7;
            ++n4;
        }
    }

    private static short mul(int n2, int n3) {
        n3 &= 0xFFFF;
        if ((n2 &= 0xFFFF) != 0) {
            if (n3 != 0) {
                int n4 = n2 * n3;
                return (short)(n3 - n2 + ((n3 = n4 & 0xFFFF) < (n2 = n4 >>> 16) ? 1 : 0));
            }
            return (short)(1 - n2);
        }
        return (short)(1 - n3);
    }
}

