/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class MARS
extends BlockCipher {
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 32;
    private static final int[] S = new int[]{164676729, 684261344, -2069205959, -1649577337, 2113903587, -735673503, -915562028, 2037697683, -2049943506, 709580549, 480340578, -1011013731, 253699557, 1365260079, -963264005, 1300230628, -1369478156, 225635910, -14426486, -1311797629, -246873374, 1050156610, -1946861898, 2135685292, -2090655869, 630653445, 1991239556, 981021140, 1334076496, 1550107638, 554327832, -963089882, 687138854, 979413020, -750737820, 2124947652, 1382451141, 2128466219, 849419549, -1667305338, -2131302351, -1418787667, 1459329875, -1959917220, -1232775506, -769324275, 692746017, -501239213, -1374460087, -399855994, -1825156860, -1723839898, 2024244444, -1231312821, 67397523, 601578526, 1187701206, 803373364, 1512192322, 409193819, -1047476509, 132102214, 1857587222, 755878986, -1530089895, 932734733, -872770413, 1330126149, -352547672, -619632170, -1337680352, 257165307, 1634195880, -772515997, 1303025347, 1005345112, -1414815724, -1228090879, 953558943, 40378901, -1892193067, 153887614, -1077582445, 847813932, -2058666347, 96181059, 2110610893, -1607560596, -85645339, 916570928, 873652654, -229116830, 1011817841, 815982601, 1759901009, -1671316924, 1575815864, 1976437192, -1772816066, 1770785994, 607957988, 721824663, 255561118, 14700767, -60989082, -480275832, -1065790195, 93433576, -1907155340, 1979594104, 795706010, -167042642, -1779897459, 1721321579, -1877115493, -43160015, 277916911, -530117160, -625809774, -848477339, -449235692, 989021680, 1648491597, 1175298979, 2077177641, -1947086368, 346734704, 361229653, 989691198, -755851775, 698995190, -273609645, -818182385, -1273719972, 1715758573, 38456007, 1504134337, 489240231, -598209882, -816362328, 67795472, 1826101255, -1969701300, -1395744669, -1019309387, -773791683, -1289596546, 546487571, 946547786, 1390992728, 1483042299, 1350697841, 1098979478, -482873474, -744509159, -914420234, 1761517595, -1588549915, 1428523362, -344984549, -674640518, -1508258402, -1125083786, 645054579, -268174532, 1253549323, 344199786, 1216063921, -1504720442, -157975223, 951085685, -578789427, 1674613967, -182675042, 447009603, -1203154284, -828404071, -1073948816, -943557172, 931419047, 2065808947, 964641213, 1318375729, -1832116328, 1494608465, -1711775305, -912782712, 494206303, -1331390984, 1632497360, -1250455830, 1497463085, -91176456, 871900340, -996781198, 1073141072, 1285947072, -2043614876, 1530903510, 2107796040, -1308417254, 69825812, 761500422, 783364425, 379867762, 1394891168, -1906358158, -110704679, 118656448, 222616418, -1345792723, 0x6316131, -667359282, 465837312, 976129039, -360479874, -1182502019, 330975377, -990332599, -1495880525, -1575629362, -2091285621, 1808902705, -176562862, 565788563, -183015551, 410910174, -380966026, 725155156, 1126031834, -1422309339, -1697446769, -538299734, 1704227811, 1648326755, -214668199, -1422215547, 860268811, 1800815678, -958529032, -1925046336, -1693527796, -1997430295, 1421996073, 2112542075, -1921276890, 1291130762, 1427799242, 446324488, -53063239, 627069314, -518011197, -1224894858, 863711271, -1211569388, -1637887952, 1800921940, -1382990601, 2115397773, 1485253225, 741328863, -477508410, 812879345, 136619828, -512132469, -1532439173, 1532827963, -928501605, 1945741688, 1933151538, 257513278, -371250429, -391792952, -2071132412, -1730178110, 1913265603, 1750017434, -1808029624, -1506344622, -2042929501, -780429429, 1838897391, 175115732, -1489160513, -1905653719, -2037007340, -480562105, -1824864920, -2003521502, 793844775, -570700740, 0x6662B6, 293372926, 1309848596, -1027823770, 976219152, -195681248, 1434005034, 1190516823, -824564274, -1017111237, 1811983174, -273900504, -1279045561, 1629355747, 628896263, -36338558, 991221839, 599706468, -1602882653, 143625901, 128840024, 2006357052, -87376067, -1063833395, -144205463, -633017875, 746933266, 898850723, 788888991, 1762010360, 481344253, 2064498118, -2129714245, -91055590, 1838586391, 1732417435, 1957461253, 17720772, -2036082333, -116935264, -805033005, 361594115, 679117397, -1146603921, 158260275, 563178107, 2008378246, -1793711367, -1496979888, -1930815535, -846437700, -1546243021, 898263293, 261856572, -693491365, -30197686, -1073712242, -848827601, -487887422, -1758229758, 113898054, 1100804525, 730054725, 925102474, -883216247, 369879767, 1565083222, 905488203, 508456094, 235965, 1732667520, -1273542607, -1393286222, -897492301, 1516475879, 808085445, -1948564373, 277843876, 270679770, -1833388917, 2134429934, -1423506988, 40031253, -1356707280, -1277654342, -122502225, -621285520, -862465097, -379499668, 732872692, 1895204815, 946639190, -838258971, 32013734, 1827217002, -1149514620, -946721760, -1657048579, 101597638, -682029291, 1308867399, 406591886, 1676587584, 769389722, 1834793556, -1841868625, -102677962, 2016941611, 1500671090, -2118752416, -1154931007, 1218498061, -1497347731, -1388097413, 1905084778, -1645193297, 1152499174, 88299228, -562238155, -719711349, 1644727497, 897778449, -915473246, 1752139500, -1904751768, 1675744952, -938502280, 2042925565, 457992178, 1919520125, 1580633137, -136749522, -1579988673, -589741250, -1989208750, 1271188090, -1496204556, -1515622964, 200248134, -1586889305, 1960788151, 1310754820, -1703582201, 59672520, 539041348, -1954884417, -968868043, 407429997, -2135052232, 509774108, 1681727751, -1090201864, 554249356, -163253367, 125321294, 2071506360, -1564136109, 1108703934, -1574617554, 2079585454, -2131389191, -1791912729, 2011927277, -1283364560, -628255946, -1086032791, -227699581, -294670635, 1899434549, -566075533, -1260019901, 2109615438, 758624645, 1239194211, -1732010600, 318884258, 949689279, 202922125, -1541291590, 2057537116, 1910539608, 1012726954, 2099485860, 43506141, -673437648, 1261928491, 1948822356, -1360133305, 1262467973, 1764699912, 323901326, 920248511, -1366597681, -306626865, 723985550, 386839023, 2110095318, 511053590, -1324128767, -2041701477, -672500967, 985166269, -811280529, -484714622, 230601833, -1413914527, 1399912541, -5210569, -634334981, -339118154, 194556943, 978128870, -548421013, 362607146, -1030170910, 729345898, 1638484672, -1420422777, 351183088, -552779420, 430928110};
    private boolean decrypt;
    private final int[] K = new int[40];

    public MARS() {
        super(16);
    }

    private static int[] E(int n2, int n3, int n4) {
        int n5 = n2 + n3;
        int n6 = (n2 << 13 | n2 >>> 19) * n4;
        int n7 = n5 & 0x1FF;
        int n8 = S[n7];
        n6 = n6 << 5 | n6 >>> 27;
        int n9 = n6 & 0x1F;
        n5 = n5 << n9 | n5 >>> 32 - n9;
        n8 ^= n6;
        n6 = n6 << 5 | n6 >>> 27;
        n8 ^= n6;
        n9 = n6 & 0x1F;
        n8 = n8 << n9 | n8 >>> 32 - n9;
        return new int[]{n8, n5, n6};
    }

    private final void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n6 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n7 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n8 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2] & 0xFF) << 24;
        n5 += this.K[36];
        n6 += this.K[37];
        n7 += this.K[38];
        n8 += this.K[39];
        int n9 = 7;
        while (n9 >= 0) {
            n4 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n4;
            n5 = n5 >>> 24 | n5 << 8;
            n8 ^= S[n5 >>> 8 & 0xFF];
            n8 += S[256 + (n5 >>> 16 & 0xFF)];
            n7 += S[n5 >>> 24 & 0xFF];
            n6 ^= S[256 + (n5 & 0xFF)];
            switch (n9) {
                case 2: 
                case 6: {
                    n5 += n8;
                    break;
                }
                case 3: 
                case 7: {
                    n5 += n6;
                    break;
                }
            }
            --n9;
        }
        n9 = 15;
        while (n9 >= 0) {
            n4 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n4;
            n5 = n5 >>> 13 | n5 << 19;
            int[] nArray = MARS.E(n5, this.K[2 * n9 + 4], this.K[2 * n9 + 5]);
            n7 -= nArray[1];
            if (n9 < 8) {
                n6 -= nArray[0];
                n8 ^= nArray[2];
            } else {
                n8 -= nArray[0];
                n6 ^= nArray[2];
            }
            --n9;
        }
        n9 = 7;
        while (n9 >= 0) {
            n4 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n4;
            switch (n9) {
                case 0: 
                case 4: {
                    n5 -= n8;
                    break;
                }
                case 1: 
                case 5: {
                    n5 -= n6;
                    break;
                }
            }
            n5 = n5 << 24 | n5 >>> 8;
            n8 ^= S[256 + (n5 >>> 24 & 0xFF)];
            n7 -= S[n5 >>> 16 & 0xFF];
            n6 -= S[256 + (n5 >>> 8 & 0xFF)];
            n6 ^= S[n5 & 0xFF];
            --n9;
        }
        n6 -= this.K[1];
        n7 -= this.K[2];
        n8 -= this.K[3];
        byArray2[n3++] = (byte)(n5 -= this.K[0]);
        byArray2[n3++] = (byte)(n5 >>> 8);
        byArray2[n3++] = (byte)(n5 >>> 16);
        byArray2[n3++] = (byte)(n5 >>> 24);
        byArray2[n3++] = (byte)n6;
        byArray2[n3++] = (byte)(n6 >>> 8);
        byArray2[n3++] = (byte)(n6 >>> 16);
        byArray2[n3++] = (byte)(n6 >>> 24);
        byArray2[n3++] = (byte)n7;
        byArray2[n3++] = (byte)(n7 >>> 8);
        byArray2[n3++] = (byte)(n7 >>> 16);
        byArray2[n3++] = (byte)(n7 >>> 24);
        byArray2[n3++] = (byte)n8;
        byArray2[n3++] = (byte)(n8 >>> 8);
        byArray2[n3++] = (byte)(n8 >>> 16);
        byArray2[n3] = (byte)(n8 >>> 24);
    }

    private final void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n6 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n7 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n8 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2] & 0xFF) << 24;
        n5 += this.K[0];
        n6 += this.K[1];
        n7 += this.K[2];
        n8 += this.K[3];
        int n9 = 0;
        while (n9 < 8) {
            n6 ^= S[n5 & 0xFF];
            n6 += S[256 + (n5 >>> 8 & 0xFF)];
            n7 += S[n5 >>> 16 & 0xFF];
            n8 ^= S[256 + (n5 >>> 24 & 0xFF)];
            n5 = n5 >>> 24 | n5 << 8;
            switch (n9) {
                case 0: 
                case 4: {
                    n5 += n8;
                    break;
                }
                case 1: 
                case 5: {
                    n5 += n6;
                    break;
                }
            }
            n4 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n8;
            n8 = n4;
            ++n9;
        }
        n9 = 0;
        while (n9 < 16) {
            int[] nArray = MARS.E(n5, this.K[2 * n9 + 4], this.K[2 * n9 + 5]);
            n5 = n5 << 13 | n5 >>> 19;
            n7 += nArray[1];
            if (n9 < 8) {
                n6 += nArray[0];
                n8 ^= nArray[2];
            } else {
                n8 += nArray[0];
                n6 ^= nArray[2];
            }
            n4 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n8;
            n8 = n4;
            ++n9;
        }
        n9 = 0;
        while (n9 < 8) {
            switch (n9) {
                case 2: 
                case 6: {
                    n5 -= n8;
                    break;
                }
                case 3: 
                case 7: {
                    n5 -= n6;
                    break;
                }
            }
            n8 -= S[256 + (n5 >>> 16 & 0xFF)];
            n4 = n5 = n5 << 24 | n5 >>> 8;
            n5 = n6 ^= S[256 + (n5 & 0xFF)];
            n6 = n7 -= S[n5 >>> 24 & 0xFF];
            n7 = n8 ^= S[n5 >>> 8 & 0xFF];
            n8 = n4;
            ++n9;
        }
        n6 -= this.K[37];
        n7 -= this.K[38];
        n8 -= this.K[39];
        byArray2[n3++] = (byte)(n5 -= this.K[36]);
        byArray2[n3++] = (byte)(n5 >>> 8);
        byArray2[n3++] = (byte)(n5 >>> 16);
        byArray2[n3++] = (byte)(n5 >>> 24);
        byArray2[n3++] = (byte)n6;
        byArray2[n3++] = (byte)(n6 >>> 8);
        byArray2[n3++] = (byte)(n6 >>> 16);
        byArray2[n3++] = (byte)(n6 >>> 24);
        byArray2[n3++] = (byte)n7;
        byArray2[n3++] = (byte)(n7 >>> 8);
        byArray2[n3++] = (byte)(n7 >>> 16);
        byArray2[n3++] = (byte)(n7 >>> 24);
        byArray2[n3++] = (byte)n8;
        byArray2[n3++] = (byte)(n8 >>> 8);
        byArray2[n3++] = (byte)(n8 >>> 16);
        byArray2[n3] = (byte)(n8 >>> 24);
    }

    protected void coreCrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (this.decrypt) {
            this.blockDecrypt(byArray, n2, byArray2, n3);
        } else {
            this.blockEncrypt(byArray, n2, byArray2, n3);
        }
    }

    protected void coreInit(Key key, boolean bl2) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key: key is null");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("key: wrong format, RAW needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        int n2 = byArray.length;
        if (n2 != 16 && n2 != 24 && n2 != 32) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.generateSubKeys(byArray);
        this.decrypt = bl2;
    }

    private final void generateSubKeys(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = n2 / 4;
        int[] nArray = this.K;
        int[] nArray2 = new int[15];
        int[] nArray3 = new int[]{-1532439173, 1532827963, -928501605, 1945741688};
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 / 4;
            nArray2[n5] = nArray2[n5] | (byArray[n4] & 0xFF) << n4 * 8;
            ++n4;
        }
        nArray2[n4 / 4] = n4 / 4;
        int n6 = 0;
        while (n6 < 4) {
            n4 = 0;
            while (n4 < 15) {
                int n7 = n4;
                nArray2[n7] = nArray2[n7] ^ (MARS.rotl(nArray2[(n4 + 8) % 15] ^ nArray2[(n4 + 13) % 15], 3) ^ 4 * n4 + n6);
                ++n4;
            }
            int n8 = 0;
            while (n8 < 4) {
                n4 = 0;
                while (n4 < 15) {
                    nArray2[n4] = MARS.rotl(nArray2[n4] + S[nArray2[(n4 + 14) % 15] & 0x1FF], 9);
                    ++n4;
                }
                ++n8;
            }
            n4 = 0;
            while (n4 < 10) {
                nArray[10 * n6 + n4] = nArray2[4 * n4 % 15];
                ++n4;
            }
            ++n6;
        }
        n4 = 5;
        while (n4 <= 35) {
            n6 = nArray[n4] & 3;
            int n9 = nArray[n4] | 3;
            int n10 = MARS.maskFrom(n9);
            int n11 = nArray[n4 - 1] & 0x1F;
            int n12 = MARS.rotl(nArray3[n6], n11);
            nArray[n4] = n9 ^ n12 & n10;
            n4 += 2;
        }
    }

    private static int maskFrom(int n2) {
        int n3 = (~n2 ^ n2 >>> 1) & Integer.MAX_VALUE;
        n3 &= n3 >>> 1 & n3 >>> 2;
        n3 &= n3 >>> 3 & n3 >>> 6;
        n3 <<= 1;
        n3 |= n3 << 1;
        n3 |= n3 << 2;
        n3 |= n3 << 4;
        return n3 & 0xFFFFFFFC;
    }

    private static int rotl(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }
}

