/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class Square
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int KEY_LENGTH = 10;
    private static final int R = 8;
    private static final byte[] SE;
    private static final byte[] SD;
    private static final int[] TE;
    private static final int[] TD;
    private static final int ROOT = 501;
    private static final int[] OFFSET;
    private int[][] sKey = new int[9][4];
    private boolean decrypt;

    static {
        int n2;
        SE = new byte[256];
        SD = new byte[256];
        TE = new int[256];
        TD = new int[256];
        OFFSET = new int[8];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byArray[0] = 1;
        int n3 = 1;
        while (n3 < 256) {
            n2 = byArray[n3 - 1] << 1;
            if ((n2 & 0x100) != 0) {
                n2 ^= 0x1F5;
            }
            byArray[n3] = (byte)n2;
            byArray2[n2 & 0xFF] = (byte)n3;
            ++n3;
        }
        Square.SE[0] = 0;
        Square.SE[1] = 1;
        n3 = 2;
        while (n3 < 256) {
            Square.SE[n3] = byArray[255 - byArray2[n3] & 0xFF];
            ++n3;
        }
        int[] nArray = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        n3 = 0;
        while (n3 < 256) {
            int n4 = 177;
            n2 = 0;
            while (n2 < 8) {
                int n5 = SE[n3] & nArray[n2] & 0xFF;
                n5 ^= n5 >>> 4;
                n5 ^= n5 >>> 2;
                n5 ^= n5 >>> 1;
                n4 ^= (n5 &= 1) << n2;
                ++n2;
            }
            Square.SE[n3] = (byte)n4;
            Square.SD[n4] = (byte)n3;
            ++n3;
        }
        Square.OFFSET[0] = 1;
        n3 = 1;
        while (n3 < 8) {
            Square.OFFSET[n3] = Square.mul(OFFSET[n3 - 1], 2);
            int n6 = n3 - 1;
            OFFSET[n6] = OFFSET[n6] << 24;
            ++n3;
        }
        OFFSET[7] = OFFSET[7] << 24;
        n3 = 0;
        while (n3 < 256) {
            int n7 = SE[n3] & 0xFF;
            int n8 = SD[n3] & 0xFF;
            Square.TE[n3] = SE[n3 & 3] == 0 ? 0 : Square.mul(n7, 2) << 24 | n7 << 16 | n7 << 8 | Square.mul(n7, 3);
            Square.TD[n3] = SD[n3 & 3] == 0 ? 0 : Square.mul(n8, 14) << 24 | Square.mul(n8, 9) << 16 | Square.mul(n8, 13) << 8 | Square.mul(n8, 11);
            ++n3;
        }
    }

    public Square() {
        super(16);
    }

    protected void coreCrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (this.decrypt) {
            this.square(byArray, n2, byArray2, n3, TD, SD);
        } else {
            this.square(byArray, n2, byArray2, n3, TE, SE);
        }
    }

    protected void coreInit(Key key, boolean bl2) throws InvalidKeyException {
        this.makeKey(key, bl2 ^ true);
        this.decrypt = bl2;
    }

    private void makeKey(Key key, boolean bl2) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException("Invalid user key length");
        }
        int n2 = 0;
        if (bl2) {
            int n3 = 0;
            while (n3 < 4) {
                this.sKey[0][n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                ++n3;
            }
            n3 = 1;
            while (n3 < 9) {
                n2 = n3 - 1;
                this.sKey[n3][0] = this.sKey[n2][0] ^ Square.rot32L(this.sKey[n2][3], 8) ^ OFFSET[n2];
                this.sKey[n3][1] = this.sKey[n2][1] ^ this.sKey[n3][0];
                this.sKey[n3][2] = this.sKey[n2][2] ^ this.sKey[n3][1];
                this.sKey[n3][3] = this.sKey[n2][3] ^ this.sKey[n3][2];
                Square.transform(this.sKey[n2], this.sKey[n2]);
                ++n3;
            }
        } else {
            int[][] nArray = new int[9][4];
            int n4 = 0;
            while (n4 < 4) {
                nArray[0][n4] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                ++n4;
            }
            n4 = 1;
            while (n4 < 9) {
                n2 = n4 - 1;
                nArray[n4][0] = nArray[n2][0] ^ Square.rot32L(nArray[n2][3], 8) ^ OFFSET[n2];
                nArray[n4][1] = nArray[n2][1] ^ nArray[n4][0];
                nArray[n4][2] = nArray[n2][2] ^ nArray[n4][1];
                nArray[n4][3] = nArray[n2][3] ^ nArray[n4][2];
                ++n4;
            }
            n4 = 0;
            while (n4 < 8) {
                System.arraycopy(nArray[8 - n4], 0, this.sKey[n4], 0, 4);
                ++n4;
            }
            Square.transform(nArray[0], this.sKey[8]);
        }
    }

    private static final int mul(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        n2 &= 0xFF;
        n3 &= 0xFF;
        int n4 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                n4 ^= n2;
            }
            if ((n2 <<= 1) > 255) {
                n2 ^= 0x1F5;
            }
            n3 >>>= 1;
        }
        return n4 & 0xFF;
    }

    private static int rot32L(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private static int rot32R(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    private void square(byte[] byArray, int n2, byte[] byArray2, int n3, int[] nArray, byte[] byArray3) {
        int n4 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n6 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n7 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        n4 ^= this.sKey[0][0];
        n5 ^= this.sKey[0][1];
        n6 ^= this.sKey[0][2];
        n7 ^= this.sKey[0][3];
        int n8 = 1;
        while (n8 < 8) {
            int n9 = nArray[n4 >>> 24 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 24 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 24 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 24 & 0xFF], 24) ^ this.sKey[n8][0];
            int n10 = nArray[n4 >>> 16 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 16 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 16 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 16 & 0xFF], 24) ^ this.sKey[n8][1];
            int n11 = nArray[n4 >>> 8 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 8 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 8 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 8 & 0xFF], 24) ^ this.sKey[n8][2];
            int n12 = nArray[n4 & 0xFF] ^ Square.rot32R(nArray[n5 & 0xFF], 8) ^ Square.rot32R(nArray[n6 & 0xFF], 16) ^ Square.rot32R(nArray[n7 & 0xFF], 24) ^ this.sKey[n8][3];
            n4 = n9;
            n5 = n10;
            n6 = n11;
            n7 = n12;
            ++n8;
        }
        n8 = 0;
        int n13 = 24;
        while (n8 < 4) {
            int n14 = (byArray3[n4 >>> n13 & 0xFF] & 0xFF) << 24 | (byArray3[n5 >>> n13 & 0xFF] & 0xFF) << 16 | (byArray3[n6 >>> n13 & 0xFF] & 0xFF) << 8 | byArray3[n7 >>> n13 & 0xFF] & 0xFF;
            byArray2[n3++] = (byte)((n14 ^= this.sKey[8][n8]) >>> 24 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 16 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 8 & 0xFF);
            byArray2[n3++] = (byte)(n14 & 0xFF);
            ++n8;
            n13 -= 8;
        }
    }

    private static void transform(int[] nArray, int[] nArray2) {
        int n2 = 0;
        while (n2 < 4) {
            int n3 = nArray[n2];
            int n4 = n3 >>> 8;
            int n5 = n3 >>> 16;
            int n6 = n3 >>> 24;
            int n7 = ((Square.mul(n6, 2) ^ Square.mul(n5, 3) ^ n4 ^ n3) & 0xFF) << 24;
            n7 ^= ((n6 ^ Square.mul(n5, 2) ^ Square.mul(n4, 3) ^ n3) & 0xFF) << 16;
            n7 ^= ((n6 ^ n5 ^ Square.mul(n4, 2) ^ Square.mul(n3, 3)) & 0xFF) << 8;
            nArray2[n2] = n7 ^= (Square.mul(n6, 3) ^ n5 ^ n4 ^ Square.mul(n3, 2)) & 0xFF;
            ++n2;
        }
    }
}

