/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    private BigInteger privG;
    private BigInteger privP;
    private BigInteger privX;
    private BigInteger masterSecret;
    private int masterSecretLen;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_NEED_PUB_KEY = 1;
    private static final int STATE_COMPLETE = 2;
    private int state = 0;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);

    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        if (!bl2) {
            throw new IllegalArgumentException("lastPhase: not 'true'");
        }
        if (!(key instanceof DHPublicKey)) {
            throw new IllegalArgumentException("key: not a DHPublicKey");
        }
        DHPublicKey dHPublicKey = (DHPublicKey)key;
        BigInteger bigInteger = dHPublicKey.getY();
        BigInteger bigInteger2 = dHPublicKey.getParams().getG();
        BigInteger bigInteger3 = dHPublicKey.getParams().getP();
        if (!bigInteger2.equals(this.privG) || !bigInteger3.equals(this.privP)) {
            throw new InvalidKeyException("key: incompatible group");
        }
        this.masterSecret = bigInteger.modPow(this.privX, this.privP);
        if (bl2) {
            this.state = 2;
        }
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        byte[] byArray = new byte[this.masterSecretLen];
        byte[] byArray2 = this.masterSecret.toByteArray();
        int n2 = (this.masterSecret.bitLength() + 7) / 8;
        System.out.println("this.masterSecret.bitLength(): " + this.masterSecret.bitLength());
        System.out.println("toCopy            : " + n2);
        System.out.println("returnBuf.length  : " + byArray.length);
        System.out.println("integerBuf.length : " + byArray2.length);
        System.arraycopy(byArray2, 0, byArray, byArray.length - n2, n2);
        return byArray;
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new RuntimeException("NYI");
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        int n3 = byArray2.length;
        if (n3 > byArray.length + n2) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return n3;
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("key: not a DHPrivateKey");
        }
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
        BigInteger bigInteger = dHPrivateKey.getX();
        BigInteger bigInteger2 = dHPrivateKey.getParams().getG();
        BigInteger bigInteger3 = dHPrivateKey.getParams().getP();
        if (!bigInteger3.testBit(0)) {
            throw new InvalidKeyException("key: P is not odd");
        }
        if (bigInteger2.compareTo(ZERO) != 1 || bigInteger2.compareTo(bigInteger3) != -1) {
            throw new InvalidKeyException("key: G is invalid");
        }
        this.privX = bigInteger;
        this.privG = bigInteger2;
        this.privP = bigInteger3;
        this.masterSecretLen = (bigInteger3.bitLength() + 7) / 8;
        System.out.println("privP.bitLen: " + this.privP.bitLength());
        System.out.println("masterSecretLen: " + this.masterSecretLen);
        this.state = 1;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }
}

