/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import cryptix.jce.provider.dh.DHPrivateKeyCryptix;
import cryptix.jce.provider.dh.DHPublicKeyCryptix;
import cryptix.jce.provider.util.Group;
import cryptix.jce.provider.util.Precomputed;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final int KEYSIZE_MIN = 384;
    private static final int KEYSIZE_MAX = 16384;
    private static final int KEYSIZE_DEFAULT = 16384;
    private static final int CERTAINTY = 80;
    private SecureRandom random;
    private BigInteger p;
    private BigInteger g;
    private int xLen;
    private boolean initialized = false;

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        if (!this.initialized) {
            this.initialize();
        }
        while ((bigInteger = new BigInteger(this.xLen, this.random)).compareTo(ZERO) != 1 || bigInteger.compareTo(this.p.subtract(ONE)) != -1) {
        }
        BigInteger bigInteger2 = this.g.modPow(bigInteger, this.p);
        DHParameterSpec dHParameterSpec = new DHParameterSpec(this.p, this.g);
        DHPrivateKeyCryptix dHPrivateKeyCryptix = new DHPrivateKeyCryptix(bigInteger, dHParameterSpec);
        DHPublicKeyCryptix dHPublicKeyCryptix = new DHPublicKeyCryptix(bigInteger2, dHParameterSpec);
        return new KeyPair(dHPublicKeyCryptix, dHPrivateKeyCryptix);
    }

    private void initialize() {
        this.initialize(16384, new SecureRandom());
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 384 || n2 > 16384) {
            throw new IllegalArgumentException("keysize: invalid size (" + n2 + ")");
        }
        Group group = Precomputed.getStrongGroup(n2);
        if (group == null) {
            throw new RuntimeException("keysize: sorry, no parameters available");
        }
        this.p = group.getP();
        this.g = group.getG();
        this.xLen = this.p.bitLength() - 1;
        this.random = secureRandom;
        this.initialized = true;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        BigInteger bigInteger = dHParameterSpec.getP();
        BigInteger bigInteger2 = dHParameterSpec.getG();
        int n2 = dHParameterSpec.getL();
        this.p = bigInteger;
        this.g = bigInteger2;
        this.xLen = n2 == 0 ? bigInteger.bitLength() - 1 : n2;
        this.random = secureRandom;
        this.initialized = true;
    }
}

