/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

final class DHPrivateKeyCryptix
implements DHPrivateKey {
    private final BigInteger x;
    private final DHParameterSpec params;

    DHPrivateKeyCryptix(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        this.x = bigInteger;
        this.params = dHParameterSpec;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MPIOutputStream mPIOutputStream = new MPIOutputStream(byteArrayOutputStream);
            mPIOutputStream.write(this.params.getP());
            mPIOutputStream.write(BigInteger.valueOf(this.params.getL()));
            mPIOutputStream.write(this.params.getG());
            mPIOutputStream.write(this.x);
            mPIOutputStream.flush();
            mPIOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PANIC");
        }
    }

    public String getFormat() {
        return "Cryptix";
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public BigInteger getX() {
        return this.x;
    }
}

