/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import java.math.BigInteger;
import java.security.SignatureException;

class SignatureData {
    private BigInteger r;
    private BigInteger s;

    public SignatureData(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        if (bigInteger == null || bigInteger2 == null) {
            throw new SignatureException("Invalid signature");
        }
        if (bigInteger.signum() != 1 || bigInteger2.signum() != 1) {
            throw new SignatureException("Invalid signature");
        }
        this.r = bigInteger;
        this.s = bigInteger2;
    }

    public SignatureData(byte[] byArray) throws SignatureException {
        try {
            int n2;
            int n3 = 0;
            if (byArray[n3++] != 48 || byArray[n3++] != byArray.length - 2 || byArray[n3++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((n2 = byArray[n3++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] byArray2 = new byte[n2];
            int n4 = 0;
            while (n4 < n2) {
                byArray2[n4] = byArray[n3++];
                ++n4;
            }
            if (byArray[n3++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((n2 = byArray[n3++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] byArray3 = new byte[n2];
            int n5 = 0;
            while (n5 < n2) {
                byArray3[n5] = byArray[n3++];
                ++n5;
            }
            this.r = new BigInteger(byArray2);
            this.s = new BigInteger(byArray3);
            if (n3 != byArray.length || this.r.signum() != 1 || this.s.signum() != 1) {
                throw new SignatureException("Corrupted signature data");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new SignatureException("Corrupted signature data");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Corrupted signature data");
        }
    }

    public byte[] getData() {
        byte[] byArray = this.r.toByteArray();
        byte[] byArray2 = this.s.toByteArray();
        byte[] byArray3 = new byte[6 + byArray.length + byArray2.length];
        int n2 = 0;
        byArray3[n2++] = 48;
        byArray3[n2++] = (byte)(byArray3.length - 2);
        byArray3[n2++] = 2;
        byArray3[n2++] = (byte)byArray.length;
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray3[n2++] = byArray[n3];
            ++n3;
        }
        byArray3[n2++] = 2;
        byArray3[n2++] = (byte)byArray2.length;
        int n4 = 0;
        while (n4 < byArray2.length) {
            byArray3[n2++] = byArray2[n4];
            ++n4;
        }
        return byArray3;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }
}

