/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.key;

import cryptix.jce.provider.key.RawKeyGenerator;

public class TripleDESKeyGenerator
extends RawKeyGenerator {
    private static final int STRENGTH = 168;
    private static final int BIT_LEN = 192;

    public TripleDESKeyGenerator() {
        super("TripleDES", 168);
    }

    protected byte[] fixUp(byte[] byArray) {
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by2 = byArray[n2];
            byArray[n2] = (byte)(by2 & 0xFE | (by2 >> 1 ^ by2 >> 2 ^ by2 >> 3 ^ by2 >> 4 ^ by2 >> 5 ^ by2 >> 6 ^ by2 >> 7) & 1);
            ++n2;
        }
        return byArray;
    }

    protected boolean isValidSize(int n2) {
        return n2 == 168;
    }

    protected boolean isWeak(byte[] byArray) {
        return false;
    }

    protected int strengthToBits(int n2) {
        if (n2 != 168) {
            throw new RuntimeException("Invalid strength value (" + n2 + ")");
        }
        return 192;
    }
}

