/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.mac;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

class HMAC
extends MacSpi {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private final MessageDigest md;
    private final int mdBlockSize;
    private final int mdLen;
    private final byte[] iv_i;
    private final byte[] iv_o;

    protected HMAC(String string, int n2, int n3) {
        try {
            this.md = MessageDigest.getInstance(string);
            this.mdBlockSize = n2;
            this.mdLen = n3;
            this.iv_i = new byte[n2];
            this.iv_o = new byte[n2];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Underlying MesageDigest not found: " + string);
        }
    }

    private HMAC(MessageDigest messageDigest, int n2, int n3, byte[] byArray, byte[] byArray2) {
        this.md = messageDigest;
        this.mdBlockSize = n2;
        this.mdLen = n3;
        this.iv_i = new byte[n2];
        this.iv_o = new byte[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        MessageDigest messageDigest = (MessageDigest)this.md.clone();
        return new HMAC(messageDigest, this.mdBlockSize, this.mdLen, (byte[])this.iv_i.clone(), (byte[])this.iv_o.clone());
    }

    protected final byte[] engineDoFinal() {
        byte[] byArray = this.md.digest();
        this.md.reset();
        this.md.update(this.iv_o);
        this.md.update(byArray);
        byte[] byArray2 = this.md.digest();
        this.engineReset();
        return byArray2;
    }

    protected final int engineGetMacLength() {
        return this.mdLen;
    }

    protected final void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("HMAC doesn't take AlgorithmParameters.");
        }
        if (!key.getFormat().equals("RAW")) {
            throw new InvalidKeyException("HMAC accepts keys in 'RAW' format only.");
        }
        byte[] byArray = key.getEncoded();
        if (byArray.length > this.mdBlockSize) {
            this.md.reset();
            byArray = this.md.digest(byArray);
        }
        int n2 = 0;
        while (n2 < this.iv_i.length) {
            this.iv_o[n2] = 0;
            this.iv_i[n2] = 0;
            ++n2;
        }
        System.arraycopy(byArray, 0, this.iv_i, 0, byArray.length);
        int n3 = 0;
        while (n3 < this.iv_i.length) {
            int n4 = n3++;
            this.iv_i[n4] = (byte)(this.iv_i[n4] ^ 0x36);
        }
        System.arraycopy(byArray, 0, this.iv_o, 0, byArray.length);
        int n5 = 0;
        while (n5 < this.iv_i.length) {
            int n6 = n5++;
            this.iv_o[n6] = (byte)(this.iv_o[n6] ^ 0x5C);
        }
        this.engineReset();
    }

    protected final void engineReset() {
        this.md.reset();
        this.md.update(this.iv_i);
    }

    protected final void engineUpdate(byte by2) {
        this.md.update(by2);
    }

    protected final void engineUpdate(byte[] byArray, int n2, int n3) {
        this.md.update(byArray, n2, n3);
    }
}

