/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import cryptix.jce.provider.md.PaddingMD;

public class SHA256
extends PaddingMD
implements Cloneable {
    private static final int HASH_SIZE = 32;
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private final int[] context;
    private final int[] buffer;

    public SHA256() {
        super(32, 1);
        this.context = new int[8];
        this.buffer = new int[64];
        this.coreReset();
    }

    private SHA256(SHA256 sHA256) {
        super(sHA256);
        this.context = (int[])sHA256.context.clone();
        this.buffer = (int[])sHA256.buffer.clone();
    }

    private final int Ch(int n2, int n3, int n4) {
        return n2 & n3 ^ ~n2 & n4;
    }

    private final int Maj(int n2, int n3, int n4) {
        return n2 & n3 ^ n2 & n4 ^ n3 & n4;
    }

    private final int R(int n2, int n3) {
        return n3 >>> n2;
    }

    private final int S(int n2, int n3) {
        return n3 >>> n2 | n3 << 32 - n2;
    }

    private final int Sig0(int n2) {
        return this.S(2, n2) ^ this.S(13, n2) ^ this.S(22, n2);
    }

    private final int Sig1(int n2) {
        return this.S(6, n2) ^ this.S(11, n2) ^ this.S(25, n2);
    }

    public Object clone() {
        return new SHA256(this);
    }

    protected void coreDigest(byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < this.context.length) {
            int n4 = 0;
            while (n4 < 4) {
                byArray[n2 + (n3 * 4 + (3 - n4))] = (byte)(this.context[n3] >>> 8 * n4);
                ++n4;
            }
            ++n3;
        }
    }

    protected void coreReset() {
        this.context[0] = 1779033703;
        this.context[1] = -1150833019;
        this.context[2] = 1013904242;
        this.context[3] = -1521486534;
        this.context[4] = 1359893119;
        this.context[5] = -1694144372;
        this.context[6] = 528734635;
        this.context[7] = 1541459225;
    }

    protected void coreUpdate(byte[] byArray, int n2) {
        int[] nArray = this.buffer;
        int n3 = 0;
        while (n3 < 16) {
            nArray[n3] = byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            ++n3;
        }
        int n4 = 16;
        while (n4 < 64) {
            nArray[n4] = this.sig1(nArray[n4 - 2]) + nArray[n4 - 7] + this.sig0(nArray[n4 - 15]) + nArray[n4 - 16];
            ++n4;
        }
        int n5 = this.context[0];
        int n6 = this.context[1];
        int n7 = this.context[2];
        int n8 = this.context[3];
        int n9 = this.context[4];
        int n10 = this.context[5];
        int n11 = this.context[6];
        int n12 = this.context[7];
        int n13 = 0;
        while (n13 < 64) {
            int n14 = n12 + this.Sig1(n9) + this.Ch(n9, n10, n11) + K[n13] + nArray[n13];
            int n15 = this.Sig0(n5) + this.Maj(n5, n6, n7);
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8 + n14;
            n8 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n14 + n15;
            ++n13;
        }
        this.context[0] = this.context[0] + n5;
        this.context[1] = this.context[1] + n6;
        this.context[2] = this.context[2] + n7;
        this.context[3] = this.context[3] + n8;
        this.context[4] = this.context[4] + n9;
        this.context[5] = this.context[5] + n10;
        this.context[6] = this.context[6] + n11;
        this.context[7] = this.context[7] + n12;
    }

    private final int sig0(int n2) {
        return this.S(7, n2) ^ this.S(18, n2) ^ this.R(3, n2);
    }

    private final int sig1(int n2) {
        return this.S(17, n2) ^ this.S(19, n2) ^ this.R(10, n2);
    }
}

