/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.random;

final class StatisticalTests {
    private static final int[] ONE_COUNT;

    static {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 3;
        nArray[12] = 2;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 4;
        ONE_COUNT = nArray;
    }

    private StatisticalTests() {
    }

    public static boolean looksRandom(byte[] byArray) {
        return StatisticalTests.testMonobit(byArray) && StatisticalTests.testPoker(byArray);
    }

    public static boolean testMonobit(byte[] byArray) {
        if (byArray.length != 2500) {
            throw new IllegalArgumentException("2500 bytes expected");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 2500) {
            int n4 = ONE_COUNT[byArray[n3] >> 4 & 0xF];
            int n5 = ONE_COUNT[byArray[n3] & 0xF];
            n2 += n4 + n5;
            ++n3;
        }
        return n2 > 9654 && n2 < 10346;
    }

    public static boolean testPoker(byte[] byArray) {
        if (byArray.length != 2500) {
            throw new IllegalArgumentException("2500 bytes expected");
        }
        int[] nArray = new int[16];
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xF;
            nArray[n3] = nArray[n3] + 1;
            int n4 = byArray[n2] >>> 4 & 0xF;
            nArray[n4] = nArray[n4] + 1;
            ++n2;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < 16) {
            n5 += nArray[n6] * nArray[n6];
            ++n6;
        }
        float f2 = 16.0f * (float)n5 / 5000.0f - 5000.0f;
        return f2 > 1.03f && f2 < 57.4f;
    }
}

