/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.util;

import java.math.BigInteger;

public final class Util {
    public static final BigInteger BI_ZERO = BigInteger.valueOf(0L);
    public static final BigInteger BI_ONE = BigInteger.valueOf(1L);

    private Util() {
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null ^ byArray2 == null) {
            return false;
        }
        int n2 = byArray.length;
        int n3 = byArray2.length;
        if (n2 != n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (byArray[n4] != byArray2[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static byte[] toFixedLenByteArray(BigInteger bigInteger, int n2) {
        int n3;
        if (bigInteger.signum() != 1) {
            throw new IllegalArgumentException("BigInteger not positive.");
        }
        byte[] byArray = bigInteger.toByteArray();
        int n4 = byArray.length;
        if (n4 <= 0) {
            throw new IllegalArgumentException("BigInteger too small.");
        }
        int n5 = n3 = byArray[0] == 0 ? 1 : 0;
        if ((n4 -= n3) > n2) {
            throw new IllegalArgumentException("BigInteger too large.");
        }
        byte[] byArray2 = new byte[n2];
        int n6 = n2 - n4;
        System.arraycopy(byArray, n3, byArray2, n6, n4);
        return byArray2;
    }
}

