/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.Support;

public class Mac {
    private static final int STATE_UNDEFINED = 0;
    private static final int STATE_INITIALIZED = 1;
    private int state;
    private final MacSpi spi;
    private final Provider provider;
    private final String algorithm;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this(macSpi, provider, string, 0);
    }

    private Mac(MacSpi macSpi, Provider provider, String string, int n2) {
        this.spi = macSpi;
        this.provider = provider;
        this.algorithm = string;
        this.state = n2;
    }

    public final Object clone() throws CloneNotSupportedException {
        MacSpi macSpi = (MacSpi)this.spi.clone();
        return new Mac(macSpi, this.provider, this.algorithm, this.state);
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        byte[] byArray = this.spi.engineDoFinal();
        this.reset();
        return byArray;
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.update(byArray);
        return this.doFinal();
    }

    public final void doFinal(byte[] byArray, int n2) throws ShortBufferException, IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        int n3 = this.getMacLength();
        if (byArray.length - n2 < n3) {
            throw new ShortBufferException("Buffer too short");
        }
        byte[] byArray2 = this.spi.engineDoFinal();
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        this.reset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        Object[] objectArray = Support.getImplementation("Mac", string);
        return new Mac((MacSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] objectArray = Support.getImplementation("Mac", string, string2);
        return new Mac((MacSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final int getMacLength() {
        return this.spi.engineGetMacLength();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.spi.engineInit(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("This Mac requires an AlgorithmParameterSpec");
        }
        this.state = 1;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(key, algorithmParameterSpec);
        this.state = 1;
    }

    public final void reset() {
        this.spi.engineReset();
    }

    public final void update(byte by2) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.spi.engineUpdate(by2);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.spi.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.spi.engineUpdate(byArray, n2, n3);
    }
}

