/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private final byte[] key;

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKeySpec(byte[] byArray, int n2) throws InvalidKeyException {
        if (byArray.length - n2 < 8) {
            throw new InvalidKeyException("Wrong size");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n2, this.key, 0, 8);
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public static boolean isParityAdjusted(byte[] byArray, int n2) throws InvalidKeyException {
        throw new RuntimeException("Method not yet implemented.");
    }

    public static boolean isWeak(byte[] byArray, int n2) throws InvalidKeyException {
        int n3 = (byArray[n2] & 0xFE) << 8 | byArray[n2 + 1] & 0xFE;
        int n4 = (byArray[n2 + 2] & 0xFE) << 8 | byArray[n2 + 3] & 0xFE;
        int n5 = (byArray[n2 + 4] & 0xFE) << 8 | byArray[n2 + 5] & 0xFE;
        int n6 = (byArray[n2 + 6] & 0xFE) << 8 | byArray[n2 + 7] & 0xFE;
        return !(n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278 || n5 != 0 && n5 != 65278 || n6 != 0 && n6 != 65278);
    }
}

