/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;

public class ObjectName
implements Serializable {
    private static final long serialVersionUID = 1081892073854801359L;
    private transient String m_domain;
    private transient Hashtable m_properties;
    private transient String m_propertiesString;
    private transient boolean m_isPropertyPattern;
    private transient boolean m_isDomainPattern;
    private transient int m_hashCode;
    private static HashMap m_cache = new HashMap();
    static /* synthetic */ Class class$javax$management$ObjectName;

    public ObjectName(String name) throws MalformedObjectNameException {
        this.parse(name);
    }

    public ObjectName(String domain, Hashtable table) throws MalformedObjectNameException {
        if (domain == null) {
            domain = "";
        }
        this.init(domain, table, null);
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException {
        if (key == null || value == null || key.trim().length() == 0 || value.trim().length() == 0) {
            throw new MalformedObjectNameException("No property specified");
        }
        if (domain == null) {
            domain = "";
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(key, value);
        this.init(domain, table, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String objectName) throws MalformedObjectNameException {
        boolean isSubclass = this.getClass() != (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ObjectName.class$("javax.management.ObjectName")) : class$javax$management$ObjectName);
        boolean alreadyExists = false;
        if (!isSubclass) {
            HashMap hashMap = m_cache;
            synchronized (hashMap) {
                ObjectName name = (ObjectName)m_cache.get(objectName);
                if (name != null) {
                    this.m_domain = name.getDomain();
                    this.m_properties = name.getKeyPropertyList();
                    this.m_propertiesString = name.getKeyPropertyListString();
                    this.m_isDomainPattern = name.isDomainPattern();
                    this.m_isPropertyPattern = name.isPropertyPattern();
                    this.m_hashCode = name.hashCode();
                    alreadyExists = true;
                }
            }
        }
        if (!alreadyExists) {
            String domain = this.parseDomain(objectName);
            String propertiesList = this.parsePropertiesList(objectName);
            Hashtable table = this.createPropertiesMap(propertiesList);
            this.init(domain, table, propertiesList);
            if (!isSubclass) {
                HashMap hashMap = m_cache;
                synchronized (hashMap) {
                    m_cache.put(objectName, this);
                }
            }
        }
    }

    private String parseDomain(String objectName) throws MalformedObjectNameException {
        int colon = objectName.indexOf(58);
        if (colon < 0) {
            throw new MalformedObjectNameException("Missing ':' character in ObjectName");
        }
        String domain = objectName.substring(0, colon);
        return domain;
    }

    private String parsePropertiesList(String objectName) throws MalformedObjectNameException {
        int colon = objectName.indexOf(58);
        if (colon < 0) {
            throw new MalformedObjectNameException("Missing ':' character in ObjectName");
        }
        String list = objectName.substring(colon + 1);
        return list;
    }

    private void init(String domain, Hashtable properties, String propertiesString) throws MalformedObjectNameException {
        if (properties == null || properties.size() < 1) {
            throw new MalformedObjectNameException("No property[ies] specified");
        }
        String dom = domain.trim();
        this.checkDomain(dom);
        this.m_domain = dom;
        this.checkProperties(properties);
        this.m_properties = properties;
        this.m_propertiesString = propertiesString == null ? this.convertPropertiesToString(properties) : (this.isPropertyPattern() ? this.parseProperties(propertiesString) : propertiesString);
        this.m_hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int hash = this.getDomain().hashCode();
        hash ^= this.m_properties.hashCode();
        return hash ^= new Boolean(this.isPropertyPattern()).hashCode();
    }

    private String parseProperties(String properties) {
        StringBuffer b2 = new StringBuffer();
        boolean firstTime = true;
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            String property = tokenizer.nextToken().trim();
            if (property.equals("*")) continue;
            if (!firstTime) {
                b2.append(",");
            } else {
                firstTime = false;
            }
            b2.append(property);
        }
        return b2.toString();
    }

    private void checkDomain(String domain) throws MalformedObjectNameException {
        if (domain.indexOf(58) >= 0) {
            throw new MalformedObjectNameException("Domain cannot contain ':' characters");
        }
        if (domain.indexOf(44) >= 0) {
            throw new MalformedObjectNameException("Domain cannot contain ',' characters");
        }
        if (domain.indexOf(61) >= 0) {
            throw new MalformedObjectNameException("Domain cannot contain '=' characters");
        }
        if (domain.indexOf(42) >= 0 || domain.indexOf(63) >= 0) {
            this.m_isDomainPattern = true;
        }
    }

    private void checkProperties(Hashtable properties) {
        if (properties.containsKey("*")) {
            properties.remove("*");
            this.m_isPropertyPattern = true;
        }
    }

    private Hashtable createPropertiesMap(String properties) throws MalformedObjectNameException {
        if (properties.length() < 1) {
            throw new MalformedObjectNameException("Missing property");
        }
        if (properties.charAt(properties.length() - 1) == ',') {
            throw new MalformedObjectNameException("Missing property: ObjectName cannot end with ','");
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            String property = tokenizer.nextToken().trim();
            if (property.equals("*")) {
                map.put(property, property);
                continue;
            }
            int equal = property.indexOf("=");
            if (equal < 0) {
                throw new MalformedObjectNameException("Missing '=' character in properties list");
            }
            String key = property.substring(0, equal).trim();
            if (key.length() < 1) {
                throw new MalformedObjectNameException("Missing key in properties list");
            }
            String value = property.substring(equal + 1).trim();
            if (value.length() < 1) {
                throw new MalformedObjectNameException("Missing value in properties list");
            }
            map.put(key, value);
        }
        return map;
    }

    private String convertPropertiesToString(Map properties) {
        StringBuffer b2 = new StringBuffer();
        boolean firstTime = true;
        Iterator i2 = properties.entrySet().iterator();
        while (i2.hasNext()) {
            if (!firstTime) {
                b2.append(",");
            } else {
                firstTime = false;
            }
            Map.Entry entry = i2.next();
            b2.append(entry.getKey());
            b2.append("=");
            b2.append(entry.getValue());
        }
        return b2.toString();
    }

    public String getCanonicalKeyPropertyListString() {
        TreeMap map = new TreeMap();
        map.putAll(this.m_properties);
        return this.convertPropertiesToString(map);
    }

    public String getCanonicalName() {
        return this.getDomain() + ":" + this.getCanonicalKeyPropertyListString();
    }

    public String getDomain() {
        return this.m_domain;
    }

    public String getKeyProperty(String property) {
        return (String)this.m_properties.get(property);
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this.m_properties.clone();
    }

    public String getKeyPropertyListString() {
        return this.m_propertiesString;
    }

    public boolean isPattern() {
        return this.isDomainPattern() || this.isPropertyPattern();
    }

    public boolean isPropertyPattern() {
        return this.m_isPropertyPattern;
    }

    private boolean isDomainPattern() {
        return this.m_isDomainPattern;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            ObjectName other = (ObjectName)obj;
            return this.getDomain().equals(other.getDomain()) && this.m_properties.equals(other.m_properties) && this.isPattern() == other.isPattern() && this.isPropertyPattern() == other.isPropertyPattern();
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }

    public String toString() {
        return this.getDomain() + ":" + this.getKeyPropertyListString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        StringBuffer b2 = new StringBuffer(this.getDomain());
        b2.append(":");
        String properties = this.getKeyPropertyListString();
        if (properties.indexOf(" ") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(properties, " ");
            while (tokenizer.hasMoreTokens()) {
                b2.append(tokenizer.nextToken());
            }
        } else {
            b2.append(properties);
        }
        if (this.isPropertyPattern()) {
            if (this.m_properties.isEmpty()) {
                b2.append("*");
            } else {
                b2.append(",*");
            }
        }
        String name = b2.toString();
        out.writeObject(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String objectName = (String)in.readObject();
        try {
            this.parse(objectName);
        }
        catch (MalformedObjectNameException x2) {
            throw new InvalidObjectException("String representing the ObjectName is not a valid ObjectName: " + x2.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

