/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.util.Arrays;
import java.util.List;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanNotificationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanNotificationInfo
extends MBeanNotificationInfo
implements DescriptorAccess {
    private static final long serialVersionUID = -7445681389570207141L;
    private Descriptor notificationDescriptor;

    public ModelMBeanNotificationInfo(String[] types, String name, String description) {
        this(types, name, description, null);
    }

    public ModelMBeanNotificationInfo(String[] types, String name, String description, Descriptor descriptor) {
        super(types, name, description);
        this.checkAndSetDescriptor(descriptor);
    }

    public ModelMBeanNotificationInfo(ModelMBeanNotificationInfo copy) {
        super(copy.getNotifTypes(), copy.getName(), copy.getDescription());
        this.checkAndSetDescriptor(copy.getDescriptor());
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.notificationDescriptor.clone();
    }

    public void setDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.notificationDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.notificationDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        this.notificationDescriptor = descriptor == null || !this.isDescriptorValid(descriptor) ? this.createDefaultDescriptor() : (Descriptor)descriptor.clone();
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        List<String> names = Arrays.asList(descriptor.getFieldNames());
        if (!(names.contains("name") && names.contains("descriptortype") && names.contains("severity"))) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (!name.equals(descriptor.getFieldValue("name"))) {
            return false;
        }
        if (!"notification".equals(descriptor.getFieldValue("descriptortype"))) {
            return false;
        }
        int severity = this.objectToInt(descriptor.getFieldValue("severity"));
        return severity < 1 || severity > 5;
    }

    private Descriptor createDefaultDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "severity", "displayName"};
        Object[] values = new Object[]{this.getName(), "notification", "5", this.getName()};
        return new DescriptorSupport(names, values);
    }

    private int objectToInt(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException x2) {
            return -1;
        }
    }
}

