/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import mx4j.ImplementationException;
import mx4j.log.FileLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.log.MBeanLogger;
import mx4j.persist.FilePersister;
import mx4j.persist.MBeanPersister;
import mx4j.persist.PersisterMBean;
import mx4j.util.Utils;

public class RequiredModelMBean
extends NotificationBroadcasterSupport
implements ModelMBean,
MBeanRegistration {
    private static final String OBJECT_RESOURCE_TYPE = "ObjectReference";
    private static final int ALWAYS_STALE = 1;
    private static final int NEVER_STALE = 2;
    private static final int STALE = 3;
    private static final int NOT_STALE = 4;
    private static final int PERSIST_NEVER = -1;
    private static final int PERSIST_ON_TIMER = -2;
    private static final int PERSIST_ON_UPDATE = -3;
    private static final int PERSIST_NO_MORE_OFTEN_THAN = -4;
    private MBeanServer m_mbeanServer;
    private Object m_managedResource;
    private boolean m_canBeRegistered;
    private ModelMBeanInfo m_modelMBeanInfo;
    private NotificationBroadcasterSupport m_attributeChangeBroadcaster = new NotificationBroadcasterSupport();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public RequiredModelMBean() throws MBeanException, RuntimeOperationsException {
        this(null);
    }

    public RequiredModelMBean(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            try {
                this.load();
            }
            catch (Exception x2) {
                Logger logger = this.getLogger();
                logger.warn("Cannot restore previously saved status", x2);
            }
        } else {
            this.setModelMBeanInfo(info);
        }
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.m_canBeRegistered) {
            this.m_mbeanServer = server;
            return name;
        }
        throw new MBeanRegistrationException(new IllegalStateException("ModelMBean cannot be registered until setModelMBeanInfo has been called"));
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.clear();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.clear();
    }

    private void clear() {
        this.m_mbeanServer = null;
    }

    public void setModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) throws MBeanException, RuntimeOperationsException {
        if (modelMBeanInfo == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo cannot be null"));
        }
        if (!this.isModelMBeanInfoValid(modelMBeanInfo)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is invalid"));
        }
        this.m_modelMBeanInfo = (ModelMBeanInfo)modelMBeanInfo.clone();
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("ModelMBeanInfo successfully set to: " + this.m_modelMBeanInfo);
        }
        this.m_canBeRegistered = true;
    }

    private boolean isModelMBeanInfoValid(ModelMBeanInfo info) {
        return info != null && info.getClassName() != null;
    }

    public void setManagedResource(Object resource, String resourceType) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource cannot be null"));
        }
        if (!this.isResourceTypeSupported(resourceType)) {
            throw new InvalidTargetObjectTypeException(resourceType);
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Setting managed resource to be: " + resource);
        }
        this.m_managedResource = resource;
    }

    private boolean isResourceTypeSupported(String resourceType) {
        return OBJECT_RESOURCE_TYPE.equals(resourceType);
    }

    private Object getManagedResource() {
        return this.m_managedResource;
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_modelMBeanInfo == null ? null : (MBeanInfo)this.m_modelMBeanInfo.clone();
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Listener cannot be null"));
        }
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute(attributeName);
        this.getAttributeChangeBroadcaster().addNotificationListener(listener, filter, handback);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Listener " + listener + " for attribute " + attributeName + " added successfully, handback is " + handback);
        }
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        this.removeAttributeChangeNotificationListener(listener, attributeName, null);
    }

    private void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Listener cannot be null"));
        }
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute(attributeName);
        this.getAttributeChangeBroadcaster().removeNotificationListener(listener);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Listener " + listener + " for attribute " + attributeName + " removed successfully, handback is " + handback);
        }
    }

    public void sendAttributeChangeNotification(Attribute oldAttribute, Attribute newAttribute) throws MBeanException, RuntimeOperationsException {
        if (oldAttribute == null || newAttribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
        }
        if (!oldAttribute.getName().equals(newAttribute.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names cannot be different"));
        }
        Object oldValue = oldAttribute.getValue();
        AttributeChangeNotification n2 = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value changed", oldAttribute.getName(), oldValue == null ? null : oldValue.getClass().getName(), oldValue, newAttribute.getValue());
        this.sendAttributeChangeNotification(n2);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        Logger logger;
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification cannot be null"));
        }
        this.getAttributeChangeBroadcaster().sendNotification(notification);
        Logger modelMBeanLogger = this.getModelMBeanLogger(notification.getType());
        if (modelMBeanLogger != null && modelMBeanLogger.isEnabledFor(20)) {
            modelMBeanLogger.info("ModelMBean log: " + new Date() + " - " + notification);
        }
        if ((logger = this.getLogger()).isEnabledFor(10)) {
            logger.debug("Attribute change notification " + notification + " sent");
        }
    }

    public void sendNotification(String message) throws MBeanException, RuntimeOperationsException {
        Notification notification = new Notification("jmx.modelmbean.general", (Object)this, 1L, message);
        this.sendNotification(notification);
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names cannot be null"));
        }
        Logger logger = this.getLogger();
        AttributeList list = new AttributeList();
        int i2 = 0;
        while (i2 < attributes.length) {
            block4: {
                String attrName = attributes[i2];
                Attribute attribute = null;
                try {
                    Object value = this.getAttribute(attrName);
                    attribute = new Attribute(attrName, value);
                    list.add(attribute);
                }
                catch (Exception x2) {
                    if (!logger.isEnabledFor(0)) break block4;
                    logger.trace("getAttribute for attribute " + attrName + " failed", x2);
                }
            }
            ++i2;
        }
        return list;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Descriptor attributeDescriptor;
        ModelMBeanAttributeInfo attrInfo;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        Logger logger = this.getLogger();
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            throw new AttributeNotFoundException("ModelMBeanInfo is null");
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("ModelMBeanInfo is: " + info);
        }
        if ((attrInfo = info.getAttribute(attribute)) == null) {
            throw new AttributeNotFoundException("Cannot find ModelMBeanAttributeInfo for attribute " + attribute);
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Attribute info is: " + attrInfo);
        }
        if (!attrInfo.isReadable()) {
            throw new AttributeNotFoundException("Attribute " + attribute + " is not readable");
        }
        Descriptor mbeanDescriptor = info.getMBeanDescriptor();
        if (mbeanDescriptor == null) {
            throw new AttributeNotFoundException("MBean descriptor cannot be null");
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("MBean descriptor is: " + mbeanDescriptor);
        }
        if ((attributeDescriptor = attrInfo.getDescriptor()) == null) {
            throw new AttributeNotFoundException("Attribute descriptor for attribute " + attribute + " cannot be null");
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Attribute descriptor is: " + attributeDescriptor);
        }
        Object returnValue = null;
        String lastUpdateField = "lastUpdatedTimeStamp";
        int staleness = this.getStaleness(attributeDescriptor, mbeanDescriptor, lastUpdateField);
        if (staleness == 1 || staleness == 3) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Value is stale");
            }
            String getter = (String)attributeDescriptor.getFieldValue("getMethod");
            if (logger.isEnabledFor(10)) {
                logger.debug("getMethod field is: " + getter);
            }
            if (getter == null) {
                returnValue = attributeDescriptor.getFieldValue("default");
                if (returnValue != null) {
                    Class<?> returned = returnValue.getClass();
                    Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                    this.checkAssignability(returned, declared);
                }
                logger.info("getAttribute for attribute " + attribute + " returns default value: " + returnValue);
            } else {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Invoking attribute getter...");
                }
                Object target = this.resolveTargetObject(attributeDescriptor);
                returnValue = this.invokeMethod(target, getter, new Class[0], new Object[0]);
                if (logger.isEnabledFor(10)) {
                    logger.debug("Returned value is: " + returnValue);
                }
                if (returnValue != null) {
                    Class<?> returned = returnValue.getClass();
                    Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                    this.checkAssignability(returned, declared);
                }
                if (staleness != 1) {
                    attributeDescriptor.setField("value", returnValue);
                    attributeDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Returned value has been cached");
                    }
                    info.setDescriptor(attributeDescriptor, "attribute");
                }
                logger.info("getAttribute for attribute " + attribute + " returns invoked value: " + returnValue);
            }
        } else {
            returnValue = attributeDescriptor.getFieldValue("value");
            if (returnValue != null) {
                Class<?> returned = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                this.checkAssignability(returned, declared);
            }
            logger.info("getAttribute for attribute " + attribute + " returns cached value: " + returnValue);
        }
        return returnValue;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute list cannot be null"));
        }
        Logger logger = this.getLogger();
        AttributeList list = new AttributeList();
        Iterator i2 = attributes.iterator();
        while (i2.hasNext()) {
            Attribute attribute = (Attribute)i2.next();
            String name = attribute.getName();
            try {
                this.setAttribute(attribute);
                list.add(attribute);
            }
            catch (Exception x2) {
                if (!logger.isEnabledFor(0)) continue;
                logger.trace("setAttribute for attribute " + name + " failed", x2);
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object oldValue;
        String lastUpdateField;
        Descriptor attributeDescriptor;
        Descriptor mbeanDescriptor;
        ModelMBeanAttributeInfo attrInfo;
        Object attrValue;
        String attrName;
        ModelMBeanInfo info;
        Logger logger;
        block29: {
            if (attribute == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
            }
            logger = this.getLogger();
            info = this.getModelMBeanInfo();
            if (info == null) {
                throw new AttributeNotFoundException("ModelMBeanInfo is null");
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("ModelMBeanInfo is: " + info);
            }
            attrName = attribute.getName();
            attrValue = attribute.getValue();
            attrInfo = info.getAttribute(attrName);
            if (attrInfo == null) {
                throw new AttributeNotFoundException("Cannot find ModelMBeanAttributeInfo for attribute " + attrName);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("Attribute info is: " + attrInfo);
            }
            if (!attrInfo.isWritable()) {
                throw new AttributeNotFoundException("Attribute " + attrName + " is not writable");
            }
            mbeanDescriptor = info.getMBeanDescriptor();
            if (mbeanDescriptor == null) {
                throw new AttributeNotFoundException("MBean descriptor cannot be null");
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("MBean descriptor is: " + mbeanDescriptor);
            }
            if ((attributeDescriptor = attrInfo.getDescriptor()) == null) {
                throw new AttributeNotFoundException("Attribute descriptor for attribute " + attrName + " cannot be null");
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("Attribute descriptor is: " + attributeDescriptor);
            }
            lastUpdateField = "lastUpdatedTimeStamp";
            oldValue = null;
            try {
                oldValue = this.getAttribute(attrName);
                if (logger.isEnabledFor(10)) {
                    logger.debug("Previous value of attribute " + attrName + ": " + oldValue);
                }
            }
            catch (Exception x2) {
                if (!logger.isEnabledFor(10)) break block29;
                logger.debug("Cannot get previous value of attribute " + attrName, x2);
            }
        }
        String method = (String)attributeDescriptor.getFieldValue("setMethod");
        if (logger.isEnabledFor(10)) {
            logger.debug("setMethod field is: " + method);
        }
        if (method != null) {
            Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
            if (attrValue != null) {
                Class<?> parameter = attrValue.getClass();
                this.checkAssignability(parameter, declared);
            }
            Object target = this.resolveTargetObject(attributeDescriptor);
            this.invokeMethod(target, method, new Class[]{declared}, new Object[]{attrValue});
            int staleness = this.getStaleness(attributeDescriptor, mbeanDescriptor, lastUpdateField);
            if (staleness != 1) {
                attributeDescriptor.setField("value", attrValue);
                attributeDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                if (logger.isEnabledFor(0)) {
                    logger.trace("Attribute's value has been cached");
                }
            } else if (logger.isEnabledFor(0)) {
                logger.trace("Always stale, avoiding to cache attribute's value");
            }
        } else {
            if (attrValue != null) {
                Class<?> parameter = attrValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                this.checkAssignability(parameter, declared);
            }
            attributeDescriptor.setField("value", attrValue);
        }
        info.setDescriptor(attributeDescriptor, "attribute");
        if (logger.isEnabledFor(0)) {
            logger.trace("Sending attribute change notifications");
        }
        this.sendAttributeChangeNotification(new Attribute(attrName, oldValue), attribute);
        boolean persistNow = this.shouldPersistNow(attributeDescriptor, mbeanDescriptor, lastUpdateField);
        if (persistNow) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Persisting this ModelMBean...");
            }
            try {
                this.store();
                if (logger.isEnabledFor(0)) {
                    logger.trace("ModelMBean persisted successfully");
                }
            }
            catch (Exception x3) {
                logger.error("Cannot store ModelMBean after setAttribute", x3);
                if (x3 instanceof MBeanException) {
                    throw (MBeanException)x3;
                }
                throw new MBeanException(x3);
            }
        }
    }

    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        Descriptor mbeanDescriptor;
        Descriptor operationDescriptor;
        ModelMBeanOperationInfo operInfo;
        if (method == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name cannot be null"));
        }
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (params == null) {
            params = new String[]{};
        }
        Logger logger = this.getLogger();
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            throw new MBeanException(new ServiceNotFoundException("ModelMBeanInfo is null"));
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("ModelMBeanInfo is: " + info);
        }
        if ((operInfo = info.getOperation(method)) == null) {
            throw new MBeanException(new ServiceNotFoundException("Cannot find ModelMBeanOperationInfo for operation " + method));
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Operation info is: " + operInfo);
        }
        if ((operationDescriptor = operInfo.getDescriptor()) == null) {
            throw new MBeanException(new ServiceNotFoundException("Operation descriptor for operation " + method + " cannot be null"));
        }
        String role = (String)operationDescriptor.getFieldValue("role");
        if (role == null || !role.equals("operation")) {
            throw new MBeanException(new ServiceNotFoundException("Operation descriptor field 'role' must be 'operation', not " + role));
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Operation descriptor is: " + operationDescriptor);
        }
        if ((mbeanDescriptor = info.getMBeanDescriptor()) == null) {
            throw new MBeanException(new ServiceNotFoundException("MBean descriptor cannot be null"));
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("MBean descriptor is: " + mbeanDescriptor);
        }
        Object returnValue = null;
        String lastUpdateField = "lastReturnedTimeStamp";
        int staleness = this.getStaleness(operationDescriptor, mbeanDescriptor, lastUpdateField);
        if (staleness == 1 || staleness == 3) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Value is stale");
            }
            Object target = this.resolveTargetObject(operationDescriptor);
            Class[] parameters = null;
            try {
                parameters = Utils.loadClasses(Thread.currentThread().getContextClassLoader(), params);
            }
            catch (ClassNotFoundException x2) {
                logger.error("Cannot find operation's parameter classes", x2);
                throw new ReflectionException(x2);
            }
            if (logger.isEnabledFor(0)) {
                logger.trace("Invoking operation...");
            }
            returnValue = this.invokeMethod(target, method, parameters, arguments);
            if (logger.isEnabledFor(10)) {
                logger.debug("Returned value is: " + returnValue);
            }
            if (returnValue != null) {
                Class<?> parameter = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(operInfo.getReturnType());
                this.checkAssignability(parameter, declared);
            }
            if (staleness != 1) {
                operationDescriptor.setField("lastReturnedValue", returnValue);
                operationDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                if (logger.isEnabledFor(0)) {
                    logger.trace("Returned value has been cached");
                }
                info.setDescriptor(operationDescriptor, "operation");
            }
            if (logger.isEnabledFor(20)) {
                logger.info("invoke for operation " + method + " returns invoked value: " + returnValue);
            }
        } else {
            returnValue = operationDescriptor.getFieldValue("lastReturnedValue");
            if (returnValue != null) {
                Class<?> parameter = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(operInfo.getReturnType());
                this.checkAssignability(parameter, declared);
            }
            if (logger.isEnabledFor(20)) {
                logger.info("invoke for operation " + method + " returns cached value: " + returnValue);
            }
        }
        boolean persistNow = this.shouldPersistNow(operationDescriptor, null, lastUpdateField);
        int impact = operInfo.getImpact();
        if (persistNow && impact != 0) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Persisting this ModelMBean...");
            }
            try {
                this.store();
                if (logger.isEnabledFor(0)) {
                    logger.trace("ModelMBean persisted successfully");
                }
            }
            catch (Exception x3) {
                logger.error("Cannot store ModelMBean after operation invocation", x3);
                if (x3 instanceof MBeanException) {
                    throw (MBeanException)x3;
                }
                throw new MBeanException(x3);
            }
        }
        return returnValue;
    }

    private Object resolveTargetObject(Descriptor descriptor) throws MBeanException {
        Logger logger = this.getLogger();
        Object target = descriptor.getFieldValue("targetObject");
        if (logger.isEnabledFor(0)) {
            logger.trace("targetObject is: " + target);
        }
        if (target == null) {
            target = this.getManagedResource();
            if (target == null) {
                throw new MBeanException(new ServiceNotFoundException("Managed resource is null"));
            }
        } else {
            String targetObjectType = (String)descriptor.getFieldValue("targetObjectType");
            if (logger.isEnabledFor(0)) {
                logger.trace("targetObjectType is: " + targetObjectType);
            }
            if (targetObjectType == null) {
                targetObjectType = OBJECT_RESOURCE_TYPE;
            }
            if (!this.isResourceTypeSupported(targetObjectType)) {
                throw new MBeanException(new InvalidTargetObjectTypeException(targetObjectType));
            }
        }
        return target;
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        PersisterMBean persister = this.findPersister();
        if (persister != null) {
            ModelMBeanInfo info = (ModelMBeanInfo)persister.load();
            this.setModelMBeanInfo(info);
        }
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        PersisterMBean persister = this.findPersister();
        if (persister != null) {
            ModelMBeanInfo info = (ModelMBeanInfo)((Object)this.getMBeanInfo());
            persister.store(info);
        }
    }

    private boolean shouldPersistNow(Descriptor attribute, Descriptor mbean, String lastUpdateField) {
        int persist = this.getPersistPolicy(attribute, mbean);
        if (persist == -4) {
            Long lastUpdate;
            Long period = this.getFieldTimeValue(attribute, mbean, "persistPeriod");
            long now = System.currentTimeMillis();
            return now - (lastUpdate = (Long)attribute.getFieldValue(lastUpdateField)) >= period;
        }
        if (persist == -1) {
            return false;
        }
        if (persist == -2) {
            return false;
        }
        if (persist == -3) {
            return true;
        }
        throw new ImplementationException("Invalid persist value");
    }

    private int getPersistPolicy(Descriptor descriptor, Descriptor mbean) {
        Logger logger = this.getLogger();
        String persist = (String)descriptor.getFieldValue("persistPolicy");
        if (persist == null && mbean != null) {
            persist = (String)mbean.getFieldValue("persistPolicy");
        }
        if (persist == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("No persist policy defined, assuming Never");
            }
            return -1;
        }
        if (persist.equals("Never")) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Persist never");
            }
            return -1;
        }
        if (persist.equals("OnUpdate")) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Persist on update");
            }
            return -3;
        }
        if (persist.equals("OnTimer")) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Persist on update");
            }
            return -2;
        }
        if (persist.equals("NoMoreOftenThan")) {
            if (logger.isEnabledFor(0)) {
                Long period = this.getFieldTimeValue(descriptor, mbean, "persistPeriod");
                logger.trace("Persist no more often than " + period);
            }
            return -4;
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Invalid persist policy, assuming persist never");
        }
        return -1;
    }

    private int getStaleness(Descriptor attribute, Descriptor mbean, String lastUpdateField) {
        long now;
        Logger logger = this.getLogger();
        Long currencyTimeLimit = this.getFieldTimeValue(attribute, mbean, "currencyTimeLimit");
        if (currencyTimeLimit == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("No currencyTimeLimit defined, assuming never stale");
            }
            return 2;
        }
        long ctl = currencyTimeLimit * 1000L;
        if (logger.isEnabledFor(0)) {
            logger.trace("currencyTimeLimit is (ms): " + ctl);
        }
        if (ctl == 0L) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Always stale");
            }
            return 1;
        }
        if (ctl < 0L) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Never stale");
            }
            return 2;
        }
        Long timestamp = (Long)attribute.getFieldValue(lastUpdateField);
        long luts = 0L;
        if (timestamp != null) {
            luts = timestamp;
        }
        if (logger.isEnabledFor(10)) {
            logger.debug(lastUpdateField + " is: " + luts);
        }
        if ((now = System.currentTimeMillis()) < luts + ctl) {
            if (timestamp == null) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Stale since was never set");
                }
                return 3;
            }
            if (logger.isEnabledFor(0)) {
                logger.trace("Not stale");
            }
            return 4;
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Stale");
        }
        return 3;
    }

    private Long getFieldTimeValue(Descriptor descriptor, Descriptor mbean, String field) {
        Logger logger = this.getLogger();
        Object value = descriptor.getFieldValue(field);
        if (logger.isEnabledFor(10)) {
            logger.debug("Descriptor's " + field + " field: " + value);
        }
        if (value == null && mbean != null) {
            value = mbean.getFieldValue(field);
            if (logger.isEnabledFor(10)) {
                logger.debug("MBean's " + field + " field: " + value);
            }
            if (value == null) {
                return null;
            }
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                long ctl = Long.parseLong((String)value);
                return new Long(ctl);
            }
            catch (NumberFormatException x2) {
                return new Long(0L);
            }
        }
        return new Long(0L);
    }

    private Object invokeMethod(Object target, String methodName, Class[] params, Object[] args) throws MBeanException, ReflectionException {
        try {
            Method method = target.getClass().getMethod(methodName, params);
            Object value = method.invoke(target, args);
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.info("Method invocation returned value: " + value);
            }
            return value;
        }
        catch (NoSuchMethodException x2) {
            throw new ReflectionException(x2);
        }
        catch (IllegalAccessException x3) {
            throw new ReflectionException(x3);
        }
        catch (IllegalArgumentException x4) {
            throw new MBeanException(x4);
        }
        catch (InvocationTargetException x5) {
            Throwable t2 = x5.getTargetException();
            if (t2 instanceof Error) {
                throw new MBeanException(new RuntimeErrorException((Error)t2));
            }
            throw new MBeanException((Exception)t2);
        }
    }

    private Logger getModelMBeanLogger(String notificationType) throws MBeanException {
        ModelMBeanInfo info = this.getModelMBeanInfo();
        Descriptor descriptor = null;
        Logger modelMBeanLogger = null;
        if (notificationType != null) {
            descriptor = info.getDescriptor(notificationType, "notification");
            modelMBeanLogger = this.findLogger(descriptor);
        }
        if (modelMBeanLogger == null && (modelMBeanLogger = this.findLogger(descriptor = info.getMBeanDescriptor())) != null) {
            return modelMBeanLogger;
        }
        return null;
    }

    private Logger findLogger(Descriptor descriptor) {
        Logger logger = this.getLogger();
        if (descriptor == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Can't find MBean logger, descriptor is null");
            }
            return null;
        }
        String log = (String)descriptor.getFieldValue("log");
        String location = (String)descriptor.getFieldValue("logFile");
        if (logger.isEnabledFor(10)) {
            logger.debug("Log fields: log=" + log + ", file=" + location);
        }
        if (log == null || !Boolean.valueOf(log).booleanValue()) {
            logger.info("Logging is not supported by this ModelMBean");
            return null;
        }
        if (location == null) {
            location = (String)descriptor.getFieldValue("logMBean");
            if (logger.isEnabledFor(10)) {
                logger.debug("Log fields: mbean=" + location);
            }
            if (location == null) {
                logger.trace("Logging is not supported by this ModelMBean");
                return null;
            }
            try {
                ObjectName objectName = new ObjectName(location);
                MBeanServer server = this.getMBeanServer();
                if (server == null) {
                    throw new MBeanException(new IllegalStateException("RequiredModelMBean is not registered"));
                }
                if (server.isRegistered(objectName)) {
                    MBeanLogger l2 = new MBeanLogger(server, objectName);
                    logger.info("ModelMBean log supported by delegating to this MBean: " + objectName);
                    return l2;
                }
                return null;
            }
            catch (MalformedObjectNameException x2) {
                logger.info("Specified logMBean field does not contain a valid ObjectName: " + location);
                return null;
            }
            catch (MBeanException x3) {
                logger.warn("logMBean field does not specify an MBean that supports logging delegation", x3);
                return null;
            }
        }
        logger.info("ModelMBean log supported on file system");
        return new FileLogger(location);
    }

    private NotificationBroadcasterSupport getAttributeChangeBroadcaster() {
        return this.m_attributeChangeBroadcaster;
    }

    private MBeanServer getMBeanServer() {
        return this.m_mbeanServer;
    }

    private ModelMBeanInfo getModelMBeanInfo() {
        return this.m_modelMBeanInfo;
    }

    private PersisterMBean findPersister() throws MBeanException, InstanceNotFoundException {
        Logger logger = this.getLogger();
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Can't find persister, ModelMBeanInfo is null");
            }
            return null;
        }
        Descriptor mbeanDescriptor = info.getMBeanDescriptor();
        if (mbeanDescriptor == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Can't find persister, MBean descriptor is null");
            }
            return null;
        }
        String location = (String)mbeanDescriptor.getFieldValue("persistLocation");
        String name = (String)mbeanDescriptor.getFieldValue("persistName");
        String mbeanName = (String)mbeanDescriptor.getFieldValue("name");
        if (logger.isEnabledFor(10)) {
            logger.debug("Persistence fields: location=" + location + ", name=" + name);
        }
        if (mbeanName == null && name == null) {
            if (logger.isEnabledFor(20)) {
                logger.info("Persistence is not supported by this ModelMBean");
            }
            return null;
        }
        if (name != null) {
            try {
                ObjectName objectName = new ObjectName(name.trim());
                MBeanServer server = this.getMBeanServer();
                if (server == null) {
                    throw new MBeanException(new IllegalStateException("RequiredModelMBean is not registered"));
                }
                if (server.isRegistered(objectName) && server.isInstanceOf(objectName, "mx4j.persist.PersisterMBean")) {
                    MBeanPersister persister = new MBeanPersister(server, objectName);
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Persistence is delegated to this MBean: " + objectName);
                    }
                    return persister;
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
            catch (MalformedObjectNameException ignored) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Persistence is not delegated to another MBean");
                }
                FilePersister persister = new FilePersister(location, name);
                if (logger.isEnabledFor(10)) {
                    logger.debug("Persistence is realized through file system in " + persister.getFileName());
                }
                return persister;
            }
        }
        FilePersister persister = new FilePersister(location, mbeanName);
        if (logger.isEnabledFor(10)) {
            logger.debug("Persistence is realized through file system in " + persister.getFileName());
        }
        return persister;
    }

    private Class loadClassWithContextClassLoader(String name) {
        try {
            return Utils.loadClass(Thread.currentThread().getContextClassLoader(), name);
        }
        catch (ClassNotFoundException x2) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Cannot find attribute's declared return class", x2);
            }
            return null;
        }
    }

    private void checkAssignability(Class parameter, Class declared) throws MBeanException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("The class of the parameter is: " + parameter);
            if (parameter != null) {
                logger.debug("The classloder of the parameter's class is: " + parameter.getClassLoader());
            }
            logger.debug("The class declared as type of the attribute is: " + declared);
            if (declared != null) {
                logger.debug("The classloader of the declared parameter's class is: " + declared.getClassLoader());
            }
        }
        boolean assignable = false;
        assignable = declared == null || parameter == null ? false : (declared == Boolean.TYPE && parameter == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = RequiredModelMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? true : (declared == Byte.TYPE && parameter == (class$java$lang$Byte == null ? (class$java$lang$Byte = RequiredModelMBean.class$("java.lang.Byte")) : class$java$lang$Byte) ? true : (declared == Character.TYPE && parameter == (class$java$lang$Character == null ? (class$java$lang$Character = RequiredModelMBean.class$("java.lang.Character")) : class$java$lang$Character) ? true : (declared == Short.TYPE && parameter == (class$java$lang$Short == null ? (class$java$lang$Short = RequiredModelMBean.class$("java.lang.Short")) : class$java$lang$Short) ? true : (declared == Integer.TYPE && parameter == (class$java$lang$Integer == null ? (class$java$lang$Integer = RequiredModelMBean.class$("java.lang.Integer")) : class$java$lang$Integer) ? true : (declared == Long.TYPE && parameter == (class$java$lang$Long == null ? (class$java$lang$Long = RequiredModelMBean.class$("java.lang.Long")) : class$java$lang$Long) ? true : (declared == Float.TYPE && parameter == (class$java$lang$Float == null ? (class$java$lang$Float = RequiredModelMBean.class$("java.lang.Float")) : class$java$lang$Float) ? true : (declared == Double.TYPE && parameter == (class$java$lang$Double == null ? (class$java$lang$Double = RequiredModelMBean.class$("java.lang.Double")) : class$java$lang$Double) ? true : declared.isAssignableFrom(parameter)))))))));
        if (!assignable) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Parameter value's class and attribute's declared return class are not assignable");
            }
            throw new MBeanException(new InvalidAttributeValueException("Returned type and declared type are not assignable"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

