/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

public class ArrayType
extends OpenType
implements Serializable {
    private static final long serialVersionUID = 720504429830309770L;
    private int dimension = 0;
    private OpenType elementType = null;
    private transient int hashCode = 0;

    public ArrayType(int dimension, OpenType elementType) throws OpenDataException {
        super(ArrayType.createArrayName(elementType, dimension), ArrayType.createArrayName(elementType, dimension), ArrayType.createDescription(elementType, dimension));
        if (elementType instanceof ArrayType) {
            throw new OpenDataException("elementType can't be instance of ArrayType");
        }
        if (dimension <= 0) {
            throw new IllegalArgumentException("int type dimension must be greater than or equal to 1");
        }
        this.dimension = dimension;
        this.elementType = elementType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementOpenType() {
        return this.elementType;
    }

    public boolean isValue(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> cls = object.getClass();
        if (!cls.isArray()) {
            return false;
        }
        String clsName = cls.getName();
        if (this.elementType instanceof SimpleType && clsName.equals(this.getClassName())) {
            return true;
        }
        if (this.elementType instanceof CompositeData || this.elementType instanceof TabularData) {
            Class<?> openTypeCls = this.elementType.getClass();
            if (!openTypeCls.isAssignableFrom(object.getClass())) {
                return false;
            }
            Object[] arr = (Object[])object;
            return !ArrayType.arrayHasNull(arr);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ArrayType) {
            ArrayType checkedType = (ArrayType)object;
            if (checkedType.dimension != this.dimension) {
                return false;
            }
            if (this.getClassName().equals(checkedType.getClassName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.elementType.getClassName());
        sb.append("(typename=");
        sb.append(this.getTypeName());
        sb.append(",dimension=");
        sb.append("" + this.dimension);
        sb.append(",elementType=");
        sb.append(this.elementType.toString());
        sb.append(")");
        return sb.toString();
    }

    private static String createDescription(OpenType type, int size) {
        StringBuffer sb = new StringBuffer("" + size);
        sb.append("-dimension array of ");
        sb.append(type.getClassName());
        return sb.toString();
    }

    private static String createArrayName(OpenType type, int size) {
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < size) {
            sb.append("[");
            ++i2;
        }
        sb.append("L");
        sb.append(type.getClassName());
        sb.append(";");
        return sb.toString();
    }

    private void computeHashCode() {
        this.hashCode = this.dimension + this.elementType.hashCode();
    }

    private static boolean arrayHasNull(Object[] obj) {
        int i2 = 0;
        while (i2 < obj.length) {
            if (obj[i2] == null) {
                return true;
            }
            if (obj[i2].getClass().isArray() && ArrayType.arrayHasNull((Object[])obj[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

