/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo,
Serializable {
    private static final long serialVersionUID = -4867215622149721849L;
    private OpenType openType;
    private Object defaultValue = null;
    private Set legalValues = null;
    private Comparable minValue = null;
    private Comparable maxValue = null;
    private transient int hashCode = 0;
    private transient String toStringName = null;

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, openType == null ? "" : openType.getClassName(), description, isReadable, isWritable, isIs);
        if (openType == null) {
            throw new IllegalArgumentException("OpenType can't be null");
        }
        if (name == null || name.length() == 0 || name.trim().equals("")) {
            throw new IllegalArgumentException("name can't be null or empty");
        }
        if (description == null || description.length() == 0 || description.trim().equals("")) {
            throw new IllegalArgumentException("description can't be null or empty");
        }
        this.openType = openType;
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs);
        if (openType instanceof ArrayType || openType instanceof TabularType) {
            if (defaultValue != null) {
                throw new IllegalArgumentException("defaultValue is not supported for ArrayType and TabularType. Should be null");
            }
        } else if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue can't be null");
        }
        if (!openType.isValue(defaultValue)) {
            throw new IllegalArgumentException("defaultValue is not a valid value for the given OpenType");
        }
        this.defaultValue = defaultValue;
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Object[] legalValues) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue);
        if (openType instanceof ArrayType || openType instanceof TabularType) {
            if (legalValues != null && legalValues.length > 0) {
                throw new OpenDataException("legalValues isn't allowed for ArrayType and TabularType. Should be null or empty array");
            }
        } else {
            if (legalValues == null || legalValues.length == 0) {
                throw new OpenDataException("legalValues cant be null or empty for given opentype");
            }
            HashSet<Object> tmpSet = new HashSet<Object>(legalValues.length, 1.0f);
            int i2 = 0;
            while (i2 < legalValues.length) {
                tmpSet.add(legalValues[i2]);
                ++i2;
            }
            Iterator i3 = tmpSet.iterator();
            while (i3.hasNext()) {
                if (openType.isValue(i3.next())) continue;
                throw new OpenDataException("An Entry in the set of legalValues is not a valid value for the given opentype");
            }
            this.legalValues = Collections.unmodifiableSet(tmpSet);
        }
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Comparable minValue, Comparable maxValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue);
        if (minValue != null && !openType.isValue(minValue)) {
            throw new IllegalArgumentException("minValue is not a valid value for the specified openType");
        }
        if (maxValue != null && !openType.isValue(minValue)) {
            throw new IllegalArgumentException("maxValue is not a valid value for the specified openType");
        }
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            throw new OpenDataException("minValue and/or maxValue is invalid: minValue is greater than maxValue");
        }
        if (defaultValue != null && minValue != null && minValue.compareTo((Comparable)defaultValue) > 0) {
            throw new OpenDataException("defaultvalue and/or minValue is invalid: minValue is greater than defaultValue");
        }
        if (defaultValue != null && maxValue != null && ((Comparable)defaultValue).compareTo(maxValue) > 0) {
            throw new OpenDataException("defaultvalue and/or maxValue is invalid: defaultValue is greater than maxValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public OpenType getOpenType() {
        return this.openType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Set getLegalValues() {
        return this.legalValues;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    public boolean hasMinValue() {
        return this.minValue != null;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    public boolean isValue(Object obj) {
        return this.defaultValue != null ? this.openType.isValue(obj) : obj == null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenMBeanAttributeInfo)) {
            return false;
        }
        OpenMBeanAttributeInfo other = (OpenMBeanAttributeInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getOpenType().equals(other.getOpenType())) {
            return false;
        }
        if (this.isReadable() != other.isReadable()) {
            return false;
        }
        if (this.isWritable() != other.isWritable()) {
            return false;
        }
        if (this.isIs() != other.isIs()) {
            return false;
        }
        if (this.hasDefaultValue() ? !this.getDefaultValue().equals(other.getDefaultValue()) : other.hasDefaultValue()) {
            return false;
        }
        if (this.hasMinValue() ? !this.minValue.equals(other.getMinValue()) : other.hasMinValue()) {
            return false;
        }
        if (this.hasMaxValue() ? !this.maxValue.equals(other.getMaxValue()) : other.hasMaxValue()) {
            return false;
        }
        return !(this.hasLegalValues() ? !this.legalValues.equals(other.getLegalValues()) : other.hasLegalValues());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + (this.getName() != null ? this.getName().hashCode() : 0);
            result = 37 * result + this.openType.hashCode();
            result = 37 * result + (this.isReadable() ? 1 : 0);
            result = 37 * result + (this.isWritable() ? 1 : 0);
            result = 37 * result + (this.isIs() ? 1 : 0);
            result = 37 * result + (this.hasDefaultValue() ? this.getDefaultValue().hashCode() : 0);
            result = 37 * result + (this.hasMinValue() ? this.getMinValue().hashCode() : 0);
            result = 37 * result + (this.hasMaxValue() ? this.getMaxValue().hashCode() : 0);
            this.hashCode = result = 37 * result + (this.hasLegalValues() ? this.getLegalValues().hashCode() : 0);
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toStringName == null) {
            StringBuffer sb = new StringBuffer(this.getClass().getName());
            sb.append("(name=");
            sb.append(this.getName());
            sb.append(", opentype=");
            sb.append(this.openType.toString());
            sb.append(", defaultValue=");
            sb.append(this.hasDefaultValue() ? this.getDefaultValue().toString() : "null");
            sb.append(", minValue=");
            sb.append(this.hasMinValue() ? this.getMinValue().toString() : "null");
            sb.append(", maxValue=");
            sb.append(this.hasMaxValue() ? this.getMaxValue().toString() : "null");
            sb.append(", legalValues=");
            sb.append(this.hasLegalValues() ? this.getLegalValues().toString() : "null");
            sb.append(")");
            this.toStringName = sb.toString();
        }
        return this.toStringName;
    }
}

