/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.timer.TimerTask;
import mx4j.util.TimeQueue;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private TimeQueue m_queue = new TimeQueue();
    private boolean m_isActive;
    private int m_notificationID;
    private HashMap m_tasks = new HashMap();
    private boolean m_sendPastNotification;
    private ObjectName m_name;

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        Logger logger = this.getLogger();
        ObjectName objectName = this.m_name = name == null ? new ObjectName(server.getDefaultDomain(), "service", "Timer") : name;
        if (logger.isEnabledFor(0)) {
            logger.trace("Timer service " + this.m_name + " preRegistered successfully");
        }
        return this.m_name;
    }

    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        boolean done = registrationDone;
        if (!done) {
            logger.warn("Timer service " + this.m_name + " was not registered");
        } else if (logger.isEnabledFor(0)) {
            logger.trace("Timer service " + this.m_name + " postRegistered successfully.");
        }
    }

    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        this.stop();
        if (logger.isEnabledFor(0)) {
            logger.trace("Timer service " + this.m_name + " preDeregistered successfully");
        }
    }

    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Timer service " + this.m_name + " postDeregistered successfully");
        }
    }

    public void start() {
        if (!this.isActive()) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Starting Timer service " + this.m_name);
            }
            this.m_queue.clear();
            this.m_queue.start();
            ArrayList tasks = this.updateTasks();
            this.scheduleTasks(tasks);
            this.m_isActive = true;
            if (logger.isEnabledFor(0)) {
                logger.trace("Timer service " + this.m_name + " started successfully");
            }
        }
    }

    public void stop() {
        if (this.isActive()) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Stopping Timer service " + this.m_name);
            }
            this.m_queue.stop();
            this.m_queue.clear();
            this.m_isActive = false;
            if (logger.isEnabledFor(0)) {
                logger.trace("Timer service " + this.m_name + " stopped successfully");
            }
        }
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period, long occurrences) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Notification date cannot be null");
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Period cannot be negative");
        }
        if (occurrences < 0L) {
            throw new IllegalArgumentException("Occurrences cannot be negative");
        }
        long now = System.currentTimeMillis();
        if (this.isActive()) {
            long lastTime;
            if (period == 0L && date.getTime() < now) {
                throw new IllegalArgumentException("Notification date cannot be before current date");
            }
            if (period > 0L && occurrences > 0L && (lastTime = date.getTime() + (occurrences - 1L) * period) < now) {
                throw new IllegalArgumentException("Notification date cannot be before current date");
            }
        }
        Integer id = this.addNotificationImpl(type, message, userData, date, period, occurrences);
        if (this.isActive()) {
            TimerTask task = this.getTask(id);
            this.updateTask(task);
            if (!task.isFinished()) {
                this.m_queue.schedule(task);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer addNotificationImpl(String type, String message, Object userData, Date date, long period, long occurrences) {
        Logger logger = this.getLogger();
        Integer id = this.createNotificationID();
        TimerNotification notification = new TimerNotification(type, (Object)this, message, id);
        notification.setUserData(userData);
        if (logger.isEnabledFor(10)) {
            logger.debug("Adding timer notification: " + notification + " on Timer service " + this.m_name);
        }
        TimerTask task = this.createTimerTask(notification, date, period, occurrences);
        Timer timer = this;
        synchronized (timer) {
            this.m_tasks.put(id, task);
        }
        return id;
    }

    private TimerTask createTimerTask(TimerNotification notification, Date date, long period, long occurrences) {
        return new TimerTask(notification, date, period, occurrences){

            public void run() {
                Timer.this.sendNotification(this.getNotification());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList updateTasks() {
        ArrayList<TimerTask> list = new ArrayList<TimerTask>();
        boolean sendPast = this.getSendPastNotifications();
        Timer timer = this;
        synchronized (timer) {
            Iterator i2 = this.m_tasks.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i2);
                if (entry == null) break;
                TimerTask task = (TimerTask)entry.getValue();
                if (!sendPast) {
                    this.updateTask(task);
                    if (task.isFinished()) continue;
                }
                list.add(task);
            }
            return list;
        }
    }

    private void updateTask(TimerTask task) {
        long now = System.currentTimeMillis();
        long time = task.getNextExecutionTime();
        while (time < now && !task.isFinished()) {
            if (task.isPeriodic()) {
                task.setNextExecutionTime(time + task.getPeriod());
                time = task.getNextExecutionTime();
                continue;
            }
            task.setFinished(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTasks(ArrayList tasks) {
        Timer timer = this;
        synchronized (timer) {
            int i2 = 0;
            while (i2 < tasks.size()) {
                TimerTask task = (TimerTask)tasks.get(i2);
                this.m_queue.schedule(task);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotification(Integer id) throws InstanceNotFoundException {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = this.getTask(id);
            if (t2 == null) {
                throw new InstanceNotFoundException("Cannot find notification to remove with id: " + id);
            }
            this.m_queue.unschedule(t2);
            this.m_tasks.remove(id);
            if (logger.isEnabledFor(10)) {
                logger.debug("Notification " + t2.getNotification() + " removed successfully from Timer service " + this.m_name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifications(String type) throws InstanceNotFoundException {
        Logger logger = this.getLogger();
        boolean found = false;
        Timer timer = this;
        synchronized (timer) {
            Iterator i2 = this.m_tasks.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i2);
                if (entry == null) break;
                TimerTask t2 = (TimerTask)entry.getValue();
                TimerNotification n2 = t2.getNotification();
                if (!n2.getType().equals(type)) continue;
                this.m_queue.unschedule(t2);
                this.m_tasks.remove(entry.getKey());
                if (logger.isEnabledFor(10)) {
                    logger.debug("Notification " + n2 + " removed successfully from Timer service " + this.m_name);
                }
                found = true;
            }
        }
        if (!found) {
            throw new InstanceNotFoundException("Cannot find timer notification to remove with type: " + type + " from Timer service " + this.m_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotifications() {
        Timer timer = this;
        synchronized (timer) {
            this.m_queue.clear();
            this.m_tasks.clear();
            this.m_notificationID = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllNotificationIDs() {
        Vector vector = new Vector();
        Timer timer = this;
        synchronized (timer) {
            Iterator i2 = this.m_tasks.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i2);
                if (entry == null) break;
                vector.add(entry.getKey());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNotificationIDs(String type) {
        Vector vector = new Vector();
        Timer timer = this;
        synchronized (timer) {
            Iterator i2 = this.m_tasks.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i2);
                if (entry == null) break;
                TimerTask t2 = (TimerTask)entry.getValue();
                TimerNotification n2 = t2.getNotification();
                if (!n2.getType().equals(type)) continue;
                vector.add(entry.getKey());
            }
        }
        return vector;
    }

    public boolean getSendPastNotifications() {
        return this.m_sendPastNotification;
    }

    public void setSendPastNotifications(boolean value) {
        this.m_sendPastNotification = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbNotifications() {
        int count = 0;
        Timer timer = this;
        synchronized (timer) {
            Iterator i2 = this.m_tasks.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i2);
                if (entry == null) break;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Timer timer = this;
        synchronized (timer) {
            return this.getNbNotifications() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNotificationType(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = this.getTask(id);
            return t2 == null ? null : t2.getNotification().getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNotificationMessage(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = this.getTask(id);
            return t2 == null ? null : t2.getNotification().getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNotificationUserData(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = this.getTask(id);
            return t2 == null ? null : t2.getNotification().getUserData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = this.getTask(id);
            return t2 == null ? null : new Date(t2.getDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getPeriod(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = this.getTask(id);
            return t2 == null ? null : new Long(t2.getPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNbOccurences(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = this.getTask(id);
            return t2 == null ? null : new Long(t2.getOccurrences());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer createNotificationID() {
        Timer timer = this;
        synchronized (timer) {
            return new Integer(++this.m_notificationID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTask getTask(Integer id) {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            TimerTask t2 = (TimerTask)this.m_tasks.get(id);
            if (logger.isEnabledFor(10)) {
                logger.debug("Retrieving task with id " + id + ": " + t2);
            }
            if (t2 != null && t2.isFinished()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Task with id " + id + " is expired, removing it");
                }
                this.m_tasks.remove(id);
                t2 = null;
            }
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry getNextNonFinishedTaskEntry(Iterator i2) {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            if (i2.hasNext()) {
                Map.Entry entry = (Map.Entry)i2.next();
                TimerTask t2 = (TimerTask)entry.getValue();
                if (t2.isFinished()) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Found an expired notification, removing it: " + t2);
                    }
                    i2.remove();
                    return this.getNextNonFinishedTaskEntry(i2);
                }
                return entry;
            }
            return null;
        }
    }

    public void sendNotification(Notification n2) {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Start sending notifications from Timer service " + this.m_name);
        }
        super.sendNotification(n2);
        if (logger.isEnabledFor(0)) {
            logger.trace("Finished sending notifications from Timer service " + this.m_name);
        }
    }
}

