/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi.jrmp;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import mx4j.adaptor.rmi.RMIAdaptor;
import mx4j.adaptor.rmi.SSLAdaptorRMIServerSocketFactory;
import mx4j.adaptor.rmi.SSLRMIClientSocketFactory;
import mx4j.adaptor.rmi.jrmp.JRMPAdaptorMBean;

public class JRMPAdaptor
extends RMIAdaptor
implements JRMPAdaptorMBean {
    private boolean m_running;
    private int m_port;
    private String m_sslFactory;

    public void start() throws RemoteException, NamingException, JMException {
        if (!this.isRunning()) {
            this.installInterceptors();
            String sslFactory = this.getSSLFactory();
            if (sslFactory != null) {
                ObjectName factory = new ObjectName(sslFactory);
                UnicastRemoteObject.exportObject(this, this.getPort(), new SSLRMIClientSocketFactory(), new SSLAdaptorRMIServerSocketFactory(this.getMBeanServer(), factory));
            } else {
                UnicastRemoteObject.exportObject((Remote)this, this.getPort());
            }
            this.bind(this);
            this.m_running = true;
        }
    }

    public void stop() throws NoSuchObjectException, NamingException {
        if (this.isRunning()) {
            UnicastRemoteObject.unexportObject(this, true);
            this.unbind();
            this.uninstallInterceptors();
            this.m_running = false;
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public String getProtocol() {
        return "rmi/jrmp";
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
        this.m_port = port;
    }

    public String getSSLFactory() {
        return this.m_sslFactory;
    }

    public void setSSLFactory(String factory) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
        this.m_sslFactory = factory;
    }
}

