/*
 * Decompiled with CFR 0.152.
 */
package mx4j.log;

public class Logger {
    public static final int TRACE = 0;
    public static final int DEBUG = 10;
    public static final int INFO = 20;
    public static final int WARN = 30;
    public static final int ERROR = 40;
    public static final int FATAL = 50;
    private int m_priority = 30;
    private String m_category;

    protected Logger() {
    }

    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public String getCategory() {
        return this.m_category;
    }

    protected void setCategory(String category) {
        this.m_category = category;
    }

    public final boolean isEnabledFor(int priority) {
        return priority >= this.getPriority();
    }

    public final void fatal(Object message) {
        this.log(50, message, null);
    }

    public final void fatal(Object message, Throwable t2) {
        this.log(50, message, t2);
    }

    public final void error(Object message) {
        this.log(40, message, null);
    }

    public final void error(Object message, Throwable t2) {
        this.log(40, message, t2);
    }

    public final void warn(Object message) {
        this.log(30, message, null);
    }

    public final void warn(Object message, Throwable t2) {
        this.log(30, message, t2);
    }

    public final void info(Object message) {
        this.log(20, message, null);
    }

    public final void info(Object message, Throwable t2) {
        this.log(20, message, t2);
    }

    public final void debug(Object message) {
        this.log(10, message, null);
    }

    public final void debug(Object message, Throwable t2) {
        this.log(10, message, t2);
    }

    public final void trace(Object message) {
        this.log(0, message, null);
    }

    public final void trace(Object message, Throwable t2) {
        this.log(0, message, t2);
    }

    protected void log(int priority, Object message, Throwable t2) {
        if (this.isEnabledFor(priority)) {
            System.out.println(message);
            if (t2 != null) {
                t2.printStackTrace(System.out);
            }
        }
    }
}

